/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.data.AbstractDataBag;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.lib.Sink;

public class DefaultDataBag<E>
extends AbstractDataBag<E> {
    private final ThresholdPolicy<E> policy;
    private final SerializationFactory<E> serializationFactory;
    protected boolean finishedAdding = false;
    protected boolean spilled = false;
    protected boolean closed = false;
    private Sink<E> serializer;
    private OutputStream out;

    public DefaultDataBag(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory) {
        this.policy = policy;
        this.serializationFactory = serializerFactory;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new AtlasException("DefaultDataBag is closed, no operations can be performed on it.");
        }
    }

    @Override
    public void add(E item) {
        this.checkClosed();
        if (this.finishedAdding) {
            throw new AtlasException("DefaultDataBag: Cannot add any more items after the writing phase is complete.");
        }
        if (!this.policy.isThresholdExceeded()) {
            this.memory.add(item);
        } else {
            if (!this.spilled) {
                this.spill();
                this.spilled = true;
            }
            this.serializer.send(item);
        }
        this.policy.increment(item);
        ++this.size;
    }

    private void spill() {
        try {
            this.out = this.getSpillStream();
        }
        catch (IOException e2) {
            throw new AtlasException(e2);
        }
        this.serializer = this.serializationFactory.createSerializer(this.out);
        for (Object e3 : this.memory) {
            this.serializer.send(e3);
        }
        this.memory = null;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public void flush() {
        if (this.policy.isThresholdExceeded() && null != this.serializer) {
            this.serializer.flush();
        }
    }

    @Override
    public Iterator<E> iterator() {
        Iterator toReturn;
        this.checkClosed();
        this.closeWriter();
        if (this.policy.isThresholdExceeded()) {
            BufferedInputStream in;
            File spillFile = this.getSpillFiles().get(0);
            try {
                in = new BufferedInputStream(new FileInputStream(spillFile));
            }
            catch (FileNotFoundException ex) {
                throw new AtlasException(ex);
            }
            Iterator<E> deserializer = this.serializationFactory.createDeserializer(in);
            IteratorResourceClosing<E> irc = new IteratorResourceClosing<E>(deserializer, in);
            this.registerCloseableIterator(irc);
            toReturn = irc;
        } else {
            toReturn = this.memory.iterator();
        }
        return toReturn;
    }

    protected void closeWriter() {
        if (!this.finishedAdding) {
            if (this.policy.isThresholdExceeded()) {
                if (null != this.serializer) {
                    this.serializer.close();
                }
                if (null != this.out) {
                    IO.close(this.out);
                }
            }
            this.finishedAdding = true;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closeWriter();
            this.closeIterators();
            this.deleteSpillFiles();
            this.memory = null;
            this.closed = true;
        }
    }
}

