/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.lang.sparql_11.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql_11.SPARQLParser11;
import com.hp.hpl.jena.sparql.lang.sparql_11.TokenMgrError;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import com.hp.hpl.jena.update.UpdateException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.slf4j.LoggerFactory;

public class ParserSPARQL11Update
extends UpdateParser {
    @Override
    protected void parse$(UpdateSink sink, String updateString) {
        StringReader r = new StringReader(updateString);
        this._parse(sink, r);
    }

    @Override
    protected void parse$(UpdateSink sink, Reader r) {
        this._parse(sink, r);
    }

    public void parse(UpdateSink sink, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQL11Update.parse - use a FileInputStream");
        }
        this._parse(sink, r);
    }

    private void _parse(UpdateSink sink, Reader r) {
        SPARQLParser11 parser = null;
        try {
            parser = new SPARQLParser11(r);
            parser.setUpdateSink(sink);
            parser.UpdateUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (UpdateException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.fatal(this, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

