/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Util;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Data
implements DataSerializable {
    public byte[] buffer = null;
    public int partitionHash = -1;

    public Data() {
    }

    public Data(byte[] bytes) {
        this.buffer = bytes;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            this.buffer = new byte[size];
            in.readFully(this.buffer);
        }
        this.partitionHash = in.readInt();
    }

    public void writeData(DataOutput out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        if (size > 0) {
            out.write(this.buffer);
        }
        out.writeInt(this.partitionHash);
    }

    public int hashCode() {
        return Util.hashCode(this.buffer);
    }

    public int getPartitionHash() {
        if (this.partitionHash == -1) {
            if (this.buffer == null) {
                throw new IllegalStateException("Cannot hash null buffer");
            }
            this.partitionHash = this.hashCode();
        }
        return this.partitionHash;
    }

    public void setPartitionHash(int partitionHash) {
        this.partitionHash = partitionHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Data)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Data data = (Data)obj;
        return this.size() == data.size() && Data.equals(this.buffer, data.buffer);
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        int length = data1.length;
        if (data2.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Data{partitionHash=" + this.partitionHash + "} size= " + this.size();
    }
}

