/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NodeValueInteger
extends NodeValue {
    BigInteger integer;

    public NodeValueInteger(BigInteger i) {
        this.integer = i;
    }

    public NodeValueInteger(BigInteger i, Node n) {
        super(n);
        this.integer = i;
    }

    public NodeValueInteger(long i) {
        this.integer = new BigInteger(Long.toString(i));
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public BigInteger getInteger() {
        return this.integer;
    }

    @Override
    public double getDouble() {
        return this.integer.doubleValue();
    }

    @Override
    public float getFloat() {
        return this.integer.floatValue();
    }

    @Override
    public BigDecimal getDecimal() {
        return new BigDecimal(this.integer);
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteral((String)this.integer.toString(), null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return this.integer.toString();
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

