/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.tdb.transaction.TransactionInfoMBean;
import com.hp.hpl.jena.tdb.transaction.TransactionManager;

public class TransactionInfo
implements TransactionInfoMBean {
    private TransactionManager transactionManager;

    public TransactionInfo(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public long getTransactionCount() {
        return this.getReadTransactionCount() + this.getWriteTransactionCount();
    }

    @Override
    public long getReadTransactionCount() {
        return this.transactionManager.finishedReaders.get();
    }

    @Override
    public long getWriteTransactionCount() {
        return this.getWriteCommitTransactionCount() + this.getWriteAbortTransactionCount();
    }

    @Override
    public long getWriteAbortTransactionCount() {
        return this.transactionManager.abortedWriters.get();
    }

    @Override
    public long getWriteCommitTransactionCount() {
        return this.transactionManager.committedWriters.get();
    }

    @Override
    public long getWriteCommitTransactionPendingCount() {
        return this.transactionManager.commitedAwaitingFlush.size();
    }

    @Override
    public long getCurrentWriteTransactionCount() {
        return this.transactionManager.activeWriters.get();
    }

    @Override
    public long getCurrentReadTransactionCount() {
        return this.transactionManager.activeReaders.get();
    }
}

