/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheSet;
import org.apache.jena.atlas.lib.CacheStats;
import org.apache.jena.atlas.lib.cache.Cache0;
import org.apache.jena.atlas.lib.cache.Cache1;
import org.apache.jena.atlas.lib.cache.CacheLRU;
import org.apache.jena.atlas.lib.cache.CacheSetLRU;
import org.apache.jena.atlas.lib.cache.CacheSetSync;
import org.apache.jena.atlas.lib.cache.CacheSimple;
import org.apache.jena.atlas.lib.cache.CacheStatsAtomic;
import org.apache.jena.atlas.lib.cache.CacheSync;
import org.apache.jena.atlas.lib.cache.CacheUnbounded;
import org.apache.jena.atlas.lib.cache.CacheWithGetter;
import org.apache.jena.atlas.lib.cache.Getter;

public class CacheFactory {
    public static <Key, Value> Cache<Key, Value> createCache(int maxSize) {
        return CacheFactory.createCache(0.75f, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createCache(float loadFactor, int maxSize) {
        return new CacheLRU(loadFactor, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createCache(Getter<Key, Value> getter, int maxSize) {
        Cache<Key, Value> cache = CacheFactory.createCache(0.75f, maxSize);
        return CacheFactory.createCacheWithGetter(cache, getter);
    }

    public static <Key, Value> Cache<Key, Value> createNullCache() {
        return new Cache0();
    }

    public static <Key, Value> Cache<Key, Value> createCacheUnbounded() {
        return new CacheUnbounded();
    }

    public static <Key, Value> Cache<Key, Value> createCacheWithGetter(Cache<Key, Value> cache, Getter<Key, Value> getter) {
        return new CacheWithGetter<Key, Value>(cache, getter);
    }

    public static <Key, Value> Cache<Key, Value> createSimpleCache(int size) {
        return new CacheSimple(size);
    }

    public static <Key, Value> Cache<Key, Value> createOneSlotCache() {
        return new Cache1();
    }

    public static <Key, Value> CacheStats<Key, Value> createStats(Cache<Key, Value> cache) {
        if (cache instanceof CacheStats) {
            return (CacheStats)cache;
        }
        return new CacheStatsAtomic<Key, Value>(cache);
    }

    public static <Key, Value> Cache<Key, Value> createSync(Cache<Key, Value> cache) {
        if (cache instanceof CacheSync) {
            return cache;
        }
        return new CacheSync<Key, Value>(cache);
    }

    public static <Obj> CacheSet<Obj> createCacheSet(int size) {
        return new CacheSetLRU(size);
    }

    public static <Obj> CacheSet<Obj> createSync(CacheSet<Obj> cache) {
        if (cache instanceof CacheSetSync) {
            return cache;
        }
        return new CacheSetSync<Obj>(cache);
    }
}

