/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class WebContent {
    public static final String contentTypeN3 = "text/rdf+n3";
    public static final String contentTypeN3Alt1 = "application/n3";
    public static final String contentTypeN3Alt2 = "text/n3";
    public static final String contentTypeTurtle = "text/turtle";
    public static final String contentTypeTurtleAlt1 = "application/turtle";
    public static final String contentTypeTurtleAlt2 = "application/x-turtle";
    public static final String contentTypeRDFXML = "application/rdf+xml";
    public static final String contentTypeRDFJSON = "application/rdf+json";
    public static final String contentTypeTextPlain = "text/plain";
    public static final String contentTypeNTriples = "application/n-triples";
    public static final String contentTypeNTriplesAlt = "text/plain";
    public static final String contentTypeXML = "application/xml";
    public static final String contentTypeXMLAlt = "text/xml";
    public static final String contentTypeTriG = "text/trig";
    public static final String contentTypeNQuads = "application/n-quads";
    public static final String contentTypeTriGAlt1 = "application/x-trig";
    public static final String contentTypeTriGAlt2 = "application/trig";
    public static final String contentTypeNQuadsAlt1 = "text/n-quads";
    public static final String contentTypeNQuadsAlt2 = "text/nquads";
    public static final String contentTypeTriX = "application/trix+xml";
    public static final String contentTypeOctets = "application/octet-stream";
    public static final String contentTypeMultiMixed = "multipart/mixed";
    public static final String contentTypeMultiFormData = "multipart/form-data";
    public static final String contentTypeMultiAlt = "multipart/alternative";
    public static final String contentTypeRdfJson = "application/rdf+json";
    public static final String contentTypeResultsXML = "application/sparql-results+xml";
    public static final String contentTypeResultsJSON = "application/sparql-results+json";
    public static final String contentTypeJSON = "application/json";
    public static final String contentTypeResultsBIO = "application/sparql-results+bio";
    public static final String contentTypeSPARQLQuery = "application/sparql-query";
    public static final String contentTypeSPARQLUpdate = "application/sparql-update";
    public static final String contentTypeForm = "application/x-www-form-urlencoded";
    public static final String contentTypeTextCSV = "text/csv";
    public static final String contentTypeTextTSV = "text/tab-separated-values";
    public static final String contentTypeSSE = "text/sse";
    public static final String charsetUTF8 = "utf-8";
    public static final String charsetASCII = "ascii";
    public static final String langRDFXML = "RDF/XML";
    public static final String langRDFXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langNTriples = "N-TRIPLES";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String langTTL = "TTL";
    public static final String langRdfJson = "RDF/JSON";
    public static final String langNQuads = "NQUADS";
    public static final String langTriG = "TRIG";
    public static final String encodingUTF8 = "utf-8";
    private static Map<String, Lang> mapContentTypeToLang = new HashMap<String, Lang>();
    private static final String defaultGraphAccept = "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7";
    public static final String defaultGraphAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7,*/*;q=0.5";
    public static final String defaultDatasetAccept = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7";
    public static final String defaultDatasetAcceptHeader = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,*/*;q=0.5";
    public static final String defaultRDFAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7,application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,*/*;q=0.5";
    private static Map<Lang, String> mapLangToContentType;

    public static String contentTypeCanonical(String contentType) {
        Lang lang = WebContent.contentTypeToLang(contentType);
        if (lang == null) {
            return null;
        }
        return mapLangToContentType.get(lang);
    }

    public static Lang contentTypeToLang(String contentType) {
        if (contentType == null) {
            return null;
        }
        return mapContentTypeToLang.get(contentType);
    }

    public static String mapLangToContentType(Lang lang) {
        return mapLangToContentType.get(lang);
    }

    public static String getCharsetForContentType(String contentType) {
        MediaType ct = MediaType.create(contentType);
        if (ct.getCharset() != null) {
            return ct.getCharset();
        }
        String mt = ct.getContentType();
        if (contentTypeNTriples.equals(mt)) {
            return "utf-8";
        }
        if ("text/plain".equals(mt)) {
            return charsetASCII;
        }
        if (contentTypeNQuads.equals(mt)) {
            return "utf-8";
        }
        if (contentTypeNQuadsAlt1.equals(mt)) {
            return charsetASCII;
        }
        if (contentTypeNQuadsAlt2.equals(mt)) {
            return charsetASCII;
        }
        return "utf-8";
    }

    static {
        mapContentTypeToLang.put(contentTypeRDFXML, RDFLanguages.RDFXML);
        mapContentTypeToLang.put(contentTypeN3, RDFLanguages.N3);
        mapContentTypeToLang.put(contentTypeN3Alt1, RDFLanguages.N3);
        mapContentTypeToLang.put(contentTypeN3Alt2, RDFLanguages.N3);
        mapContentTypeToLang.put(contentTypeTurtle, RDFLanguages.TURTLE);
        mapContentTypeToLang.put(contentTypeTurtleAlt1, RDFLanguages.TURTLE);
        mapContentTypeToLang.put(contentTypeTurtleAlt2, RDFLanguages.TURTLE);
        mapContentTypeToLang.put(contentTypeNTriples, RDFLanguages.NTRIPLES);
        mapContentTypeToLang.put("text/plain", RDFLanguages.NTRIPLES);
        mapContentTypeToLang.put("application/rdf+json", RDFLanguages.RDFJSON);
        mapContentTypeToLang.put(contentTypeNQuads, RDFLanguages.NQUADS);
        mapContentTypeToLang.put(contentTypeNQuadsAlt1, RDFLanguages.NQUADS);
        mapContentTypeToLang.put(contentTypeNQuadsAlt2, RDFLanguages.NQUADS);
        mapContentTypeToLang.put(contentTypeTriG, RDFLanguages.TRIG);
        mapContentTypeToLang.put(contentTypeTriGAlt1, RDFLanguages.TRIG);
        mapContentTypeToLang.put(contentTypeTriGAlt2, RDFLanguages.TRIG);
        mapLangToContentType = new HashMap<Lang, String>();
        mapLangToContentType.put(RDFLanguages.N3, contentTypeN3);
        mapLangToContentType.put(RDFLanguages.TURTLE, contentTypeTurtle);
        mapLangToContentType.put(RDFLanguages.NTRIPLES, contentTypeNTriples);
        mapLangToContentType.put(RDFLanguages.RDFXML, contentTypeRDFXML);
        mapLangToContentType.put(RDFLanguages.RDFJSON, "application/rdf+json");
        mapLangToContentType.put(RDFLanguages.NQUADS, contentTypeNQuads);
        mapLangToContentType.put(RDFLanguages.TRIG, contentTypeTriG);
    }
}

