/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.foresite.Agent;
import org.dspace.foresite.OREException;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.OREResourceJena;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentJena
extends OREResourceJena
implements Agent {
    @Override
    public void empty() {
    }

    @Override
    public void detach() throws OREException {
    }

    @Override
    public void initialise() {
        this.res = this.model.createResource();
        this.res.addProperty(RDF.type, (RDFNode)this.model.createResource("http://purl.org/dc/terms/Agent"));
    }

    @Override
    public void initialise(URI uri) {
        this.res = this.model.createResource(uri.toString());
        this.res.addProperty(RDF.type, (RDFNode)this.model.createResource("http://purl.org/dc/terms/Agent"));
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        StmtIterator itr = this.res.listProperties(FOAF.name);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            names.add(statement.getString());
        }
        return names;
    }

    @Override
    public void setNames(List<String> names) {
        for (String name : names) {
            this.addName(name);
        }
    }

    @Override
    public void addName(String name) {
        this.res.addProperty(FOAF.name, (RDFNode)this.model.createTypedLiteral(name));
    }

    @Override
    public List<URI> getMboxes() throws OREException {
        try {
            ArrayList<URI> mboxes = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(FOAF.mbox);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                mboxes.add(new URI(((Resource)statement.getObject()).getURI()));
            }
            return mboxes;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setMboxes(List<URI> mboxes) {
        for (URI mbox : mboxes) {
            this.addMbox(mbox);
        }
    }

    @Override
    public void addMbox(URI mbox) {
        this.res.addProperty(FOAF.mbox, (RDFNode)this.model.createResource(mbox.toString()));
    }

    @Override
    public void setTypes(List<URI> types) {
        super.setTypes(types);
        SimpleSelector selector = new SimpleSelector(this.res, RDF.type, (RDFNode)this.model.createResource("http://purl.org/dc/terms/Agent"));
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (!itr.hasNext()) {
            this.res.addProperty(RDF.type, (RDFNode)this.model.createResource("http://purl.org/dc/terms/Agent"));
        }
    }

    @Override
    public void clearTypes() {
        super.clearTypes();
        this.res.addProperty(RDF.type, (RDFNode)this.model.createResource("http://purl.org/dc/terms/Agent"));
    }

    @Override
    public Vocab getOREType() throws OREException {
        return Vocab.dcterms_Agent;
    }

    @Override
    public void setModel(Model model, URI resourceURI) throws OREException {
        this.model = model;
        this.res = model.createResource(resourceURI.toString());
    }
}

