/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dspace.foresite.OREParserException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateParser {
    public static final String timestamp = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String incompleteTimestamp = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static Date parse(String str) throws OREParserException {
        return DateParser.parse(str, 0);
    }

    private static Date parse(String str, int type) throws OREParserException {
        try {
            switch (type) {
                case 0: {
                    SimpleDateFormat sdf = new SimpleDateFormat(timestamp);
                    return sdf.parse(str);
                }
                case 1: {
                    SimpleDateFormat sdf = new SimpleDateFormat(incompleteTimestamp);
                    return sdf.parse(str);
                }
                case 2: {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
                    return dateTimeFormatter.parseDateTime(str).toDate();
                }
                case 3: {
                    DateTimeFormatter dateTimeFormatterNoMillis = ISODateTimeFormat.dateTimeNoMillis();
                    return dateTimeFormatterNoMillis.parseDateTime(str).toDate();
                }
            }
            throw new OREParserException("Unable to parse date: " + str);
        }
        catch (ParseException e) {
            return DateParser.parse(str, ++type);
        }
        catch (IllegalArgumentException e) {
            return DateParser.parse(str, ++type);
        }
        catch (NullPointerException e) {
            return DateParser.parse(str, ++type);
        }
    }
}

