/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.EmptyEnumeration;

public class Handler {
    protected Context context;
    protected ContextManager contextM;
    protected String name;
    protected boolean initialized = false;
    Hashtable initArgs = null;
    public static final int ORIGIN_WEB_XML = 0;
    public static final int ORIGIN_INVOKER = 1;
    public static final int ORIGIN_JSP = 2;
    public static final int ORIGIN_DYNAMIC = 3;
    public static final int ORIGIN_ADMIN = 4;
    protected int origin;
    protected boolean internal = false;
    protected int debug = 0;
    protected String debugHead = null;
    public static final int ACC_LAST_ACCESSED = 0;
    public static final int ACC_INVOCATION_COUNT = 1;
    public static final int ACC_SERVICE_TIME = 2;
    public static final int ACC_ERRORS = 3;
    public static final int ACC_OVERHEAD = 4;
    public static final int ACC_IN_INCLUDE = 5;
    public static final int ACCOUNTS = 6;
    long[] accTable = new long[6];
    Object[] notes = new Object[32];

    public void addInitParam(String name, String value) {
        if (this.initArgs == null) {
            this.initArgs = new Hashtable();
        }
        this.initArgs.put(name, value);
    }

    public void destroy() throws Exception {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (!this.internal) {
            this.contextM.doPreServletDestroy(this.context, (ServletWrapper)this);
        }
        this.doDestroy();
        if (!this.internal) {
            this.contextM.doPostServletDestroy(this.context, (ServletWrapper)this);
        }
    }

    protected void doDestroy() throws Exception {
    }

    protected void doInit() throws Exception {
    }

    protected void doService(Request req, Response res) throws Exception {
    }

    public long getAccount(int pos) {
        return this.accTable[pos];
    }

    public Context getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        if (this.initArgs != null) {
            return (String)this.initArgs.get(name);
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.initArgs != null) {
            return this.initArgs.keys();
        }
        return EmptyEnumeration.getEmptyEnumeration();
    }

    public String getName() {
        return this.name;
    }

    public Object getNote(int pos) {
        return this.notes[pos];
    }

    public int getOrigin() {
        return this.origin;
    }

    public void init() throws Exception {
        try {
            if (this.initialized) {
                return;
            }
            if (!(this instanceof ServletWrapper)) {
                this.doInit();
                return;
            }
            if (!this.internal) {
                this.contextM.doPreServletInit(this.context, (ServletWrapper)this);
            }
            this.doInit();
            if (!this.internal) {
                this.contextM.doPostServletInit(this.context, (ServletWrapper)this);
            }
        }
        catch (Exception ex) {
            this.initialized = false;
            throw ex;
        }
    }

    public boolean isInternal() {
        return this.internal;
    }

    protected void log(String s) {
        if (this.debugHead == null) {
            String cname = this.getClass().getName();
            this.debugHead = cname.substring(cname.lastIndexOf(".") + 1);
            this.debugHead = String.valueOf(this.debugHead) + ": ";
        }
        if (this.context != null) {
            this.context.log(String.valueOf(this.debugHead) + s);
        } else {
            System.out.println(String.valueOf(this.debugHead) + s);
        }
    }

    public void service(Request req, Response res) throws IOException, ServletException {
        if (!this.initialized) {
            Handler handler = this;
            synchronized (handler) {
                if (!this.initialized) {
                    try {
                        this.init();
                    }
                    catch (Exception ex) {
                        this.initialized = false;
                        if (ex instanceof ClassNotFoundException) {
                            this.contextM.handleStatus(req, res, 404);
                            Object var4_5 = null;
                            return;
                        }
                        this.context.log("Exception in init  " + ex.getMessage(), ex);
                        if (res.isIncluded()) {
                            res.setErrorException(ex);
                            this.contextM.saveErrorURI(req, res);
                            if (ex instanceof IOException) {
                                throw (IOException)ex;
                            }
                            if (ex instanceof ServletException) {
                                throw (ServletException)((Object)ex);
                            }
                            throw new ServletException("Servlet Init Exception", (Throwable)ex);
                        }
                        this.contextM.handleError(req, res, ex);
                        Object var4_6 = null;
                        return;
                    }
                }
            }
        }
        if (!this.internal) {
            this.contextM.doPreService(req, res);
        }
        Throwable t = null;
        try {
            this.doService(req, res);
        }
        catch (Throwable t1) {
            t = t1;
        }
        if (!this.internal) {
            this.contextM.doPostService(req, res);
        }
        if (t == null) {
            return;
        }
        if (res.isIncluded()) {
            this.contextM.saveErrorURI(req, res);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException("Servlet Exception", t);
        }
        this.contextM.handleError(req, res, t);
    }

    public void setAccount(int pos, long value) {
        this.accTable[pos] = value;
    }

    public void setContext(Context context) {
        this.context = context;
        this.contextM = context.getContextManager();
    }

    public void setDebug(int d) {
        this.debug = d;
    }

    public void setName(String servletName) {
        this.name = servletName;
    }

    public void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public String toString() {
        return this.name;
    }
}

