/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.security.SecureRandom;
import java.util.Random;

public class SessionIdGenerator {
    private static int session_count = 0;
    private static long lastTimeVal = 0L;
    private static Random randomSource;
    public static final long maxRandomLen = 2176782336L;
    public static final long maxSessionLifespanTics = 46656L;
    public static final long ticDifference = 2000L;
    private static String entropy;

    static {
        entropy = null;
    }

    public static synchronized String generateId(String jsIdent) {
        return SessionIdGenerator.getIdentifier(jsIdent);
    }

    public static String getEntropy() {
        if (entropy == null) {
            SessionIdGenerator.setEntropy(new Object().toString());
        }
        return entropy;
    }

    public static synchronized String getIdentifier(String jsIdent) {
        long n;
        StringBuffer sessionId = new StringBuffer();
        if (randomSource == null) {
            String className = System.getProperty("tomcat.sessionid.randomclass");
            if (className != null) {
                try {
                    Class<?> randomClass = Class.forName(className);
                    randomSource = (Random)randomClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (randomSource == null) {
                randomSource = new SecureRandom();
            }
            long seed = System.currentTimeMillis();
            char[] entropy = SessionIdGenerator.getEntropy().toCharArray();
            int i = 0;
            while (i < entropy.length) {
                long update = (byte)entropy[i] << i % 8 * 8;
                seed ^= update;
                ++i;
            }
            randomSource.setSeed(seed);
        }
        if ((n = randomSource.nextLong()) < 0L) {
            n = -n;
        }
        n %= 2176782336L;
        sessionId.append(Long.toString(n += 2176782336L, 36).substring(1));
        long timeVal = System.currentTimeMillis() / 2000L;
        timeVal %= 46656L;
        sessionId.append(Long.toString(timeVal += 46656L, 36).substring(1));
        if (lastTimeVal != timeVal) {
            lastTimeVal = timeVal;
            session_count = 0;
        }
        sessionId.append(Long.toString(++session_count, 36));
        if (jsIdent != null && jsIdent.length() > 0) {
            return String.valueOf(sessionId.toString()) + "." + jsIdent;
        }
        return sessionId.toString();
    }

    public static void setEntropy(String newEntropy) {
        entropy = newEntropy;
    }
}

