/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;

public class LogEvents
extends BaseInterceptor {
    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        ctx.log("Add context");
    }

    public void addMapping(Context ctx, String path, ServletWrapper servlet) throws TomcatException {
        ctx.log("Add mapping " + path + "->" + servlet);
    }

    public void addSecurityConstraint(Context ctx, String[] path, String[] methods, String transport, String[] roles) throws TomcatException {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Add security constraint ");
        if (methods != null) {
            sb.append("Methods: ");
            i = 0;
            while (i < methods.length) {
                sb.append(" " + methods[i]);
                ++i;
            }
        }
        if (path != null) {
            sb.append(" Paths: ");
            i = 0;
            while (i < path.length) {
                sb.append(" " + path[i]);
                ++i;
            }
        }
        if (roles != null) {
            sb.append(" Roles: ");
            i = 0;
            while (i < roles.length) {
                sb.append(" " + roles[i]);
                ++i;
            }
        }
        sb.append(" Transport " + transport);
        ctx.log(sb.toString());
    }

    public void addServlet(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Add servlet " + sw);
    }

    public int afterBody(Request request, Response response) {
        request.getContext().log("After Body " + request);
        return 0;
    }

    public int beforeBody(Request request, Response response) {
        request.getContext().log("Before body " + request);
        return 0;
    }

    public int beforeCommit(Request request, Response response) {
        request.getContext().log("Before commit " + request);
        return 0;
    }

    public void contextInit(Context ctx) throws TomcatException {
        ctx.log("Context Init ");
    }

    public int contextMap(Request request) {
        return 0;
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        ctx.log("Context Shutdown ");
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        cm.log("Engine init");
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        cm.log("Engine shutdown");
    }

    public int postService(Request request, Response response) {
        request.getContext().log("Post service " + request);
        return 0;
    }

    public void postServletDestroy(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Post servlet destroy " + sw);
    }

    public void postServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Post servlet init " + sw);
    }

    public int preService(Request request, Response response) {
        request.getContext().log("Pre service " + request);
        return 0;
    }

    public void preServletDestroy(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Pre servlet destroy " + sw);
    }

    public void preServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Pre servlet init " + sw);
    }

    public void removeContext(ContextManager cm, Context ctx) throws TomcatException {
        ctx.log("Remove context");
    }

    public void removeMapping(Context ctx, String path) throws TomcatException {
        ctx.log("Remove mapping ");
    }

    public void removeServlet(Context ctx, ServletWrapper sw) throws TomcatException {
        ctx.log("Remove servlet " + sw);
    }

    public int requestMap(Request request) {
        request.getContext().log("Request map " + request);
        return 0;
    }
}

