/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.Util;
import java.io.IOException;
import java.sql.SQLException;

public class RowDataDynamic
implements RowData {
    private MysqlIO io;
    private byte[][] nextRow;
    private boolean isAfterEnd = false;
    private boolean isAtEnd = false;
    private boolean streamerClosed = false;
    private int columnCount;
    private int index = -1;
    private long lastSuccessfulReadTimeMs = 0L;
    private long netWriteTimeoutMs = 0L;
    private ResultSet owner;

    public RowDataDynamic(MysqlIO io, int colCount) throws SQLException {
        this.io = io;
        this.columnCount = colCount;
        this.nextRecord();
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    public byte[][] getAt(int index) throws SQLException {
        this.notSupported();
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    public ResultSet getOwner() {
        return this.owner;
    }

    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    public void addRow(byte[][] row) throws SQLException {
        this.notSupported();
    }

    public void afterLast() throws SQLException {
        this.notSupported();
    }

    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    public void close() throws SQLException {
        int count = 0;
        while (this.hasNext()) {
            this.next();
            if (++count != 100) continue;
            Thread.yield();
            count = 0;
        }
    }

    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext && !this.streamerClosed) {
            this.io.closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    public byte[][] next() throws SQLException {
        ++this.index;
        byte[][] ret = this.nextRow;
        this.nextRecord();
        return ret;
    }

    public void removeRow(int index) throws SQLException {
        this.notSupported();
    }

    public int size() {
        return -1;
    }

    private void nextRecord() throws SQLException {
        try {
            if (!this.isAtEnd) {
                this.nextRow = this.io.nextRow(this.columnCount);
                if (this.nextRow == null) {
                    this.isAtEnd = true;
                }
                this.lastSuccessfulReadTimeMs = System.currentTimeMillis();
            } else {
                this.isAfterEnd = true;
            }
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (IOException ioEx) {
            long timeSinceLastReadMs = System.currentTimeMillis() - this.lastSuccessfulReadTimeMs;
            String exceptionType = ioEx.getClass().getName();
            String exceptionMessage = ioEx.getMessage();
            exceptionMessage = exceptionMessage + "\n\nNested Stack Trace:\n";
            exceptionMessage = exceptionMessage + Util.stackTraceToString(ioEx);
            throw new SQLException("IOException while retrieving next record in streaming result set.(Check for deadlock  or retrieval exceeding 'net_write_timeout' seconds. Last successful record read was " + timeSinceLastReadMs + " ms ago, and" + "'net_write_timeout' is configured in the server as " + this.netWriteTimeoutMs + " ms.) : " + exceptionType + " message given: " + exceptionMessage, "S1000");
        }
        catch (Exception ex) {
            String exceptionType = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            exceptionMessage = exceptionMessage + "\n\nNested Stack Trace:\n";
            exceptionMessage = exceptionMessage + Util.stackTraceToString(ex);
            throw new SQLException("Error retrieving record: Unexpected Exception: " + exceptionType + " message given: " + exceptionMessage, "S1000");
        }
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    class OperationNotSupportedException
    extends SQLException {
        OperationNotSupportedException() {
            super("Operation not supported for streaming result sets", "S1009");
        }
    }
}

