/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheControl;
import com.hp.hpl.jena.util.cache.CacheManager;

public class EnhGraph
extends Polymorphic {
    protected Graph graph;
    private static int cnt = 0;
    protected Cache enhNodes = CacheManager.createCache("ENHNODECACHE", "EnhGraph-" + cnt++, 1000);
    private Personality personality;

    public boolean isValid() {
        return true;
    }

    public EnhGraph(Graph g, Personality p) {
        this.graph = g;
        this.personality = p;
    }

    public Graph asGraph() {
        return this.graph;
    }

    public final int hashCode() {
        return this.graph.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof EnhGraph && this.graph.equals(((EnhGraph)o).asGraph());
    }

    public final boolean isIsomorphicWith(EnhGraph eg) {
        return this.graph.isIsomorphicWith(eg.graph);
    }

    public EnhNode getNodeAs(Node n, Class interf) {
        EnhNode eh = (EnhNode)this.enhNodes.get(n);
        if (eh != null) {
            return eh.viewAs(interf);
        }
        eh = (EnhNode)((GraphPersonality)this.personality).nodePersonality().newInstance(interf, n, this);
        this.enhNodes.put(n, eh);
        return eh;
    }

    public CacheControl getNodeCacheControl() {
        return this.enhNodes;
    }

    public void setNodeCache(Cache cc) {
        this.enhNodes = cc;
    }

    protected Polymorphic convertTo(Class t) {
        throw new PersonalityConfigException("Alternative perspectives on graphs has not been implemented yet");
    }

    protected boolean canSupport(Class t) {
        return false;
    }

    protected Personality getPersonality() {
        return this.personality;
    }
}

