/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public final class NameLN
extends LN {
    private static final String BEGIN_TAG = "<nameLN>";
    private static final String END_TAG = "</nameLN>";
    private DatabaseId id;
    private boolean deleted;

    public NameLN(DatabaseId id) {
        super(new byte[0]);
        this.id = id;
        this.deleted = false;
    }

    public NameLN() {
        this.id = new DatabaseId();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    void makeDeleted() {
        this.deleted = true;
    }

    public DatabaseId getId() {
        return this.id;
    }

    public void setId(DatabaseId id) {
        this.id = id;
    }

    protected long computeInMemorySize() {
        return 0L;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<id val=\"").append(this.id);
        sb.append("\">");
        sb.append('\n');
        return sb.toString();
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_NAMELN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_NAMELN;
    }

    public int getLogSize() {
        return super.getLogSize() + this.id.getLogSize() + LogUtils.getBooleanLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.id.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.deleted);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.id.readFromLog(itemBuffer);
        this.deleted = LogUtils.readBoolean(itemBuffer);
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        this.id.dumpLog(sb, true);
    }
}

