/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.Heuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicsRegistry;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;

public class Util {
    public static final String TEST_NS = "http://www.w3.org/2006/03/test-description#";

    public static Model readModel(String file) {
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(file);
        if (in == null) {
            throw new IllegalArgumentException("File: " + file + " not found");
        }
        model.read(in, null, "N3");
        return model;
    }

    public static Node createNode(String element) {
        if (element.startsWith("?")) {
            return Node.createVariable((String)element.substring(1, element.length()));
        }
        if (element.startsWith(":")) {
            return Node.createURI((String)("http://localhost/#" + element.substring(1, element.length())));
        }
        if (element.startsWith("<")) {
            return Node.createURI((String)element.substring(1, element.length() - 1));
        }
        if (element.startsWith("http:")) {
            return Node.createURI((String)element);
        }
        if (element.equals("ANY")) {
            return Node.ANY;
        }
        return Node.createLiteral((String)element);
    }

    public static Heuristic getHeuristic(String heuristic, Context context, Graph graph) {
        HeuristicsRegistry registry = new HeuristicsRegistry(context, graph);
        return registry.get(heuristic);
    }
}

