/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.ssl;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.io.Serializable;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class SSLConfigurationUtil
implements Serializable {
    public static final String SSL_KEYSTORE_TAG = "keystore";
    public static final String SSL_TAG = "ssl";
    public static final String SSL_DEBUG_TAG = "debug";
    public static final String SSL_KEYSTORE_PATH = "path";
    public static final String SSL_KEYSTORE_PASSWORD = "password";
    public static final String SSL_KEYSTORE_TYPE = "type";
    public static final String SSL_KEYSTORE_FACTORY = "factory";
    public static final String SSL_TRUSTSTORE_USE_JAVA_TRUSTSTORE = "useJavaTrustStore";
    public static final String SSL_TRUSTSTORE_USE_JAVA_TRUSTSTORE_OLD = "useJavaKeystore";
    public static final String SSL_TRUSTSTORE_TAG = "trustStore";
    public static final String SSL_TRUSTSTORE_PATH = "path";
    public static final String SSL_TRUSTSTORE_PASSWORD = "password";
    public static final String SSL_TRUSTSTORE_TYPE = "type";

    protected static SSLConfiguration getOLDSSLConfiguration(MyLoggingFacade logger, ConfigurationNode node) {
        if (logger != null) {
            logger.info("Loading an (old) SSL configuration");
        }
        SSLConfiguration sslKeystoreConfiguration = new SSLConfiguration();
        if (node == null) {
            sslKeystoreConfiguration.setUseDefaultJavaTrustStore(true);
        } else {
            sslKeystoreConfiguration.setKeystore(Configurations.getFirstAttribute((ConfigurationNode)node, (String)"path"));
            sslKeystoreConfiguration.setKeystorePassword(Configurations.getFirstAttribute((ConfigurationNode)node, (String)"password"));
            sslKeystoreConfiguration.setKeyManagerFactory(Configurations.getFirstAttribute((ConfigurationNode)node, (String)SSL_KEYSTORE_FACTORY));
            sslKeystoreConfiguration.setKeystoreType(Configurations.getFirstAttribute((ConfigurationNode)node, (String)"type"));
            String x = Configurations.getFirstAttribute((ConfigurationNode)node, (String)SSL_TRUSTSTORE_USE_JAVA_TRUSTSTORE_OLD);
            if (x == null) {
                sslKeystoreConfiguration.setUseDefaultJavaTrustStore(true);
            } else {
                sslKeystoreConfiguration.setUseDefaultJavaTrustStore(Boolean.parseBoolean(x));
            }
        }
        return sslKeystoreConfiguration;
    }

    protected static SSLConfiguration getNEWSSLConfiguration(MyLoggingFacade logger, ConfigurationNode node) {
        if (logger != null) {
            logger.info("Loading an SSL configuration");
        }
        SSLConfiguration sslKeystoreConfiguration = new SSLConfiguration();
        if (node == null) {
            if (logger != null) {
                logger.info("Using default Java trust store only.");
            }
            sslKeystoreConfiguration.setUseDefaultJavaTrustStore(true);
        } else {
            String debug = Configurations.getFirstAttribute((ConfigurationNode)node, (String)SSL_DEBUG_TAG);
            if (debug != null) {
                ConfigurationNode trustStoreNode;
                try {
                    if (Boolean.parseBoolean(debug)) {
                        if (logger != null) {
                            logger.warn("Enabled full SSL debug mode.");
                        }
                        System.setProperty("javax.net.debug", SSL_TAG);
                    } else {
                        if (logger != null) {
                            logger.info("No SSL debug enabled.");
                        }
                        System.setProperty("javax.net.debug", null);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String x = Configurations.getFirstAttribute((ConfigurationNode)node, (String)SSL_TRUSTSTORE_USE_JAVA_TRUSTSTORE);
                if (x == null) {
                    String y = Configurations.getFirstAttribute((ConfigurationNode)node, (String)SSL_TRUSTSTORE_USE_JAVA_TRUSTSTORE_OLD);
                    if (y == null) {
                        sslKeystoreConfiguration.setUseDefaultJavaTrustStore(true);
                    } else {
                        sslKeystoreConfiguration.setUseDefaultJavaTrustStore(Boolean.parseBoolean(y));
                    }
                } else {
                    sslKeystoreConfiguration.setUseDefaultJavaTrustStore(Boolean.parseBoolean(x));
                }
                ConfigurationNode keyStoreNode = Configurations.getFirstNode((ConfigurationNode)node, (String)SSL_KEYSTORE_TAG);
                if (keyStoreNode != null) {
                    sslKeystoreConfiguration.setKeystore(Configurations.getNodeValue((ConfigurationNode)keyStoreNode, (String)"path"));
                    sslKeystoreConfiguration.setKeystorePassword(Configurations.getNodeValue((ConfigurationNode)keyStoreNode, (String)"password"));
                    sslKeystoreConfiguration.setKeyManagerFactory(Configurations.getNodeValue((ConfigurationNode)keyStoreNode, (String)SSL_KEYSTORE_FACTORY));
                    sslKeystoreConfiguration.setKeystoreType(Configurations.getNodeValue((ConfigurationNode)keyStoreNode, (String)"type"));
                }
                if ((trustStoreNode = Configurations.getFirstNode((ConfigurationNode)node, (String)SSL_TRUSTSTORE_TAG)) != null) {
                    sslKeystoreConfiguration.setTrustRootPath(Configurations.getNodeValue((ConfigurationNode)trustStoreNode, (String)"path"));
                    sslKeystoreConfiguration.setTrustRootPassword(Configurations.getNodeValue((ConfigurationNode)trustStoreNode, (String)"password"));
                    sslKeystoreConfiguration.setTrustRootType(Configurations.getNodeValue((ConfigurationNode)trustStoreNode, (String)"type"));
                }
            }
            if (logger != null) {
                logger.info("Done loading SSL configuration");
            }
        }
        return sslKeystoreConfiguration;
    }

    public static SSLConfiguration getSSLConfiguration(MyLoggingFacade logger, ConfigurationNode node) {
        ConfigurationNode cfgNode = Configurations.getFirstNode((ConfigurationNode)node, (String)SSL_KEYSTORE_TAG);
        if (cfgNode != null) {
            return SSLConfigurationUtil.getOLDSSLConfiguration(logger, cfgNode);
        }
        cfgNode = Configurations.getFirstNode((ConfigurationNode)node, (String)SSL_TAG);
        return SSLConfigurationUtil.getNEWSSLConfiguration(logger, cfgNode);
    }
}

