/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.ext.ExtHash;
import com.hp.hpl.jena.tdb.index.ext.HashBucket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ExtHashIterator
implements Iterator<Record> {
    private ExtHash extHash;
    private int dictionaryIdx;
    private Iterator<Record> rBuffIterator;
    private Set<Integer> blockIds = new HashSet<Integer>();

    public ExtHashIterator(ExtHash extHash) {
        this.extHash = extHash;
        this.dictionaryIdx = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.dictionaryIdx < 0) {
            return false;
        }
        while (this.rBuffIterator == null || !this.rBuffIterator.hasNext()) {
            this.rBuffIterator = null;
            if (this.dictionaryIdx >= this.extHash.dictionarySize()) break;
            int blockId = this.extHash.getBucketId(this.dictionaryIdx);
            ++this.dictionaryIdx;
            if (this.blockIds.contains(blockId)) continue;
            HashBucket b = this.extHash.getBucket(blockId);
            this.blockIds.add(blockId);
            this.rBuffIterator = b.getRecordBuffer().iterator();
        }
        if (this.rBuffIterator == null) {
            this.finish();
            return false;
        }
        return true;
    }

    private void finish() {
        this.blockIds = null;
        this.rBuffIterator = null;
        this.extHash = null;
        this.dictionaryIdx = -99;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("ExtHashIterator");
        }
        return this.rBuffIterator.next();
    }

    @Override
    public void remove() {
    }
}

