/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.mail;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.util.mail.MailConfigurationTags;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class MailUtilProvider
extends HierarchicalConfigProvider<MailUtil>
implements MailConfigurationTags {
    MailUtil.MailEnvironment me = null;

    public MailUtilProvider() {
    }

    public MailUtilProvider(ConfigurationNode config) {
        super(config);
    }

    protected boolean checkEvent(CfgEvent cfgEvent) {
        if (cfgEvent.getConfiguration().getName().equals("mail")) {
            this.setConfig(cfgEvent.getConfiguration());
            return true;
        }
        return false;
    }

    public Object componentFound(CfgEvent configurationEvent) {
        if (this.checkEvent(configurationEvent)) {
            return this.get();
        }
        return null;
    }

    protected MailUtil.MailEnvironment getME() {
        if (this.me != null) {
            return this.me;
        }
        try {
            String x = this.getAttribute("port", "-1");
            int port = Integer.parseInt(x);
            this.me = new MailUtil.MailEnvironment(Boolean.parseBoolean(this.getAttribute("enabled", "false")), this.getAttribute("server", "none"), port, this.getAttribute("password", "changeme"), this.getAttribute("username", null), this.getAttribute("recipients"), Configurations.getNodeValue((ConfigurationNode)this.getConfig(), (String)"messageTemplate"), Configurations.getNodeValue((ConfigurationNode)this.getConfig(), (String)"subjectTemplate"), Boolean.parseBoolean(this.getAttribute("useSSL", "false")), Boolean.parseBoolean(this.getAttribute("starttls", "false")));
            return this.me;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new MyConfigurationException("Error: Could not create mail environment.", t);
        }
    }

    public MailUtil get() {
        if (this.getConfig() == null) {
            return new MailUtil();
        }
        return new MailUtil(this.getME());
    }
}

