/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.OutputBase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.out.NodeFormatterTTL;

public class TSVOutput
extends OutputBase {
    static String NL = "\n";
    static String SEP = "\t";
    static final byte[] headerBytes = StrUtils.asUTF8bytes("?_askResult" + NL);
    static final byte[] yesBytes = StrUtils.asUTF8bytes("true");
    static final byte[] noBytes = StrUtils.asUTF8bytes("false");
    static final byte[] NLBytes = StrUtils.asUTF8bytes(NL);

    @Override
    public void format(OutputStream out, ResultSet resultSet) {
        NodeFormatterTTL formatter = new NodeFormatterTTL(null, null);
        AWriter w = IO.wrapUTF8(out);
        String sep = null;
        List<String> varNames = resultSet.getResultVars();
        ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
        for (String v : varNames) {
            if (sep != null) {
                w.write(sep);
            } else {
                sep = SEP;
            }
            Var var = Var.alloc(v);
            w.write(var.toString());
            vars.add(var);
        }
        w.write(NL);
        while (resultSet.hasNext()) {
            sep = null;
            Binding b = resultSet.nextBinding();
            for (Var v : vars) {
                if (sep != null) {
                    w.write(sep);
                }
                sep = SEP;
                Node n = b.get(v);
                if (n == null) continue;
                formatter.format(w, n);
            }
            w.write(NL);
        }
        w.flush();
    }

    @Override
    public void format(OutputStream out, boolean booleanResult) {
        try {
            out.write(headerBytes);
            if (booleanResult) {
                out.write(yesBytes);
            } else {
                out.write(noBytes);
            }
            out.write(NLBytes);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

