/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.ProjectHelperImpl;
import org.apache.tools.ant.types.DataType;

public class Description
extends DataType {
    public void addText(String text) {
        ProjectHelper ph = ProjectHelper.getProjectHelper();
        if (!(ph instanceof ProjectHelperImpl)) {
            return;
        }
        String currentDescription = this.getProject().getDescription();
        if (currentDescription == null) {
            this.getProject().setDescription(text);
        } else {
            this.getProject().setDescription(currentDescription + text);
        }
    }

    public static String getDescription(Project project) {
        Vector targets = (Vector)project.getReference("ant.targets");
        if (targets == null) {
            return null;
        }
        StringBuffer description = new StringBuffer();
        for (int i = 0; i < targets.size(); ++i) {
            Target t = (Target)targets.elementAt(i);
            Description.concatDescriptions(project, t, description);
        }
        return description.toString();
    }

    private static void concatDescriptions(Project project, Target t, StringBuffer description) {
        if (t == null) {
            return;
        }
        Vector tasks = Description.findElementInTarget(project, t, "description");
        if (tasks == null) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            UnknownElement ue;
            String descComp;
            Task task = (Task)tasks.elementAt(i);
            if (!(task instanceof UnknownElement) || (descComp = (ue = (UnknownElement)task).getWrapper().getText().toString()) == null) continue;
            description.append(project.replaceProperties(descComp));
        }
    }

    private static Vector findElementInTarget(Project project, Target t, String name) {
        Task[] tasks = t.getTasks();
        Vector<Task> elems = new Vector<Task>();
        for (int i = 0; i < tasks.length; ++i) {
            if (!name.equals(tasks[i].getTaskName())) continue;
            elems.addElement(tasks[i]);
        }
        return elems;
    }
}

