/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.ecoinformatics.datamanager.database.DatabaseLoader;
import org.ecoinformatics.datamanager.download.AuthenticatedEcogridEndPointInterface;
import org.ecoinformatics.datamanager.download.DataSourceNotFoundException;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.AuthenticatedQueryServiceGetToStreamClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

public class DownloadHandler
implements Runnable {
    private static String anonymousFtpPasswd = "anonymous@domain.org";
    public static Log log = LogFactory.getLog(DownloadHandler.class);
    protected static final String ONLINE_URLS_EXCEPTION_MESSAGE = "Error reading from the data source.";
    private static final String ANONYMOUS = "anonymous";
    private static final String SRBUSERNAME = "testuser.sdsc";
    private static final String SRBPASSWD = "TESTUSER";
    private static final int SLEEPTIME = 100;
    private static final int MAXLOOPNUMBER = 200000;
    protected static Hashtable<String, DownloadHandler> handlerList = new Hashtable();
    private static String SRBENDPOINT = "http://srbbrick8.sdsc.edu:8080/SRBImpl/services/SRBQueryService";
    private static String SRBMACHINE = "srb-mcat.sdsc.edu";
    private String url = null;
    private DataStorageInterface[] dataStorageClassList = null;
    private String[] errorMessages = null;
    protected boolean completed = false;
    protected boolean success = false;
    protected boolean busy = false;
    private Exception exception = null;
    protected String ecogridEndPoint = "http://ecogrid.ecoinformatics.org/knb/services/QueryService";
    protected Entity entity = null;
    protected String sessionId = null;

    protected DownloadHandler(Entity entity, String url, EcogridEndPointInterface endPoint) {
        this(url, endPoint);
        this.entity = entity;
    }

    protected DownloadHandler(String url, EcogridEndPointInterface endPoint) {
        this.url = url;
        if (endPoint != null) {
            this.ecogridEndPoint = endPoint.getMetacatEcogridEndPoint();
            SRBENDPOINT = endPoint.getSRBEcogridEndPoint();
            SRBMACHINE = endPoint.getSRBMachineName();
            if (endPoint instanceof AuthenticatedEcogridEndPointInterface) {
                this.sessionId = ((AuthenticatedEcogridEndPointInterface)endPoint).getSessionId();
                if (this.sessionId != null) {
                    this.ecogridEndPoint = ((AuthenticatedEcogridEndPointInterface)endPoint).getMetacatAuthenticatedEcogridEndPoint();
                }
            }
        }
    }

    protected static synchronized DownloadHandler getHandlerFromHash(String source) {
        DownloadHandler handler = null;
        if (source != null) {
            handler = handlerList.get(source);
        }
        return handler;
    }

    public static DownloadHandler getInstance(String url, EcogridEndPointInterface endPoint) {
        DownloadHandler handler = DownloadHandler.getHandlerFromHash(url);
        if (handler == null) {
            log.debug((Object)("Constructing DownloadHandler for URL: " + url));
            handler = new DownloadHandler(url, endPoint);
        }
        return handler;
    }

    public static DownloadHandler getInstance(Entity entity, String url, EcogridEndPointInterface endPoint) {
        DownloadHandler handler = DownloadHandler.getHandlerFromHash(url);
        if (handler == null) {
            log.debug((Object)("Constructing DownloadHandler for URL: " + url));
            handler = new DownloadHandler(entity, url, endPoint);
        }
        return handler;
    }

    private static synchronized void putDownloadHandlerIntoHash(DownloadHandler downloadHandler) {
        String source;
        if (downloadHandler != null && (source = downloadHandler.getUrl()) != null) {
            handlerList.put(source, downloadHandler);
        }
    }

    private static synchronized void removeDownloadHandlerFromHash(DownloadHandler downloadHandler) {
        String source;
        if (downloadHandler != null && (source = downloadHandler.getUrl()) != null) {
            handlerList.remove(source);
        }
    }

    public static void setAnonymousFtpPasswd(String passwd) {
        anonymousFtpPasswd = passwd;
    }

    @Override
    public void run() {
        DownloadHandler handler = DownloadHandler.getHandlerFromHash(this.url);
        if (handler != null) {
            for (int index = 0; handler.isBusy() && index < 200000; ++index) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            this.success = handler.isSuccess();
            this.busy = false;
            this.completed = true;
            return;
        }
        DownloadHandler.putDownloadHandlerIntoHash(this);
        this.busy = true;
        this.completed = false;
        try {
            this.success = this.getContentFromSource(this.url);
        }
        catch (Exception e) {
            log.error((Object)("Error in DownloadHandler run method " + e.getMessage()));
        }
        this.waitingStorageInterfaceSerialize();
        if (this.dataStorageClassList != null) {
            for (DataStorageInterface storage : this.dataStorageClassList) {
                if (storage == null) continue;
                boolean bl = this.success = this.success && storage.isSuccess(this.url);
                if (!(storage instanceof DatabaseLoader)) continue;
                this.exception = storage.getException();
            }
        }
        DownloadHandler.removeDownloadHandlerFromHash(this);
        this.busy = false;
        this.completed = true;
    }

    private void waitingStorageInterfaceSerialize() {
        if (this.dataStorageClassList != null) {
            DataStorageInterface storage;
            int i;
            int length = this.dataStorageClassList.length;
            boolean completedInDataStorageClassList = true;
            for (i = 0; i < length; ++i) {
                storage = this.dataStorageClassList[i];
                if (storage == null || storage.doesDataExist(this.url)) continue;
                completedInDataStorageClassList = completedInDataStorageClassList && storage.isCompleted(this.url);
            }
            while (!completedInDataStorageClassList) {
                completedInDataStorageClassList = true;
                for (i = 0; i < length; ++i) {
                    storage = this.dataStorageClassList[i];
                    if (storage == null || storage.doesDataExist(this.url)) continue;
                    completedInDataStorageClassList = completedInDataStorageClassList && storage.isCompleted(this.url);
                }
            }
        }
    }

    public boolean download(DataStorageInterface[] dataStorages) throws DataSourceNotFoundException, Exception {
        this.setDataStorageClassList(dataStorages);
        Thread loadData = new Thread(this);
        loadData.start();
        for (int index = 0; !this.isCompleted() && index < 200000; ++index) {
            if (this.exception != null) {
                throw this.exception;
            }
            Thread.sleep(100L);
        }
        this.success = this.isSuccess();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.success;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public DataStorageInterface[] getDataStorageClassList() {
        return this.dataStorageClassList;
    }

    public void setDataStorageClassList(DataStorageInterface[] dataStorageClassList) {
        this.dataStorageClassList = dataStorageClassList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean getContentFromSource(String resourceName) {
        boolean successFlag;
        block39: {
            boolean onlineURLsException;
            QualityCheck onlineURLsQualityCheck;
            block37: {
                String eMessage;
                successFlag = false;
                onlineURLsQualityCheck = null;
                onlineURLsException = false;
                if (resourceName != null) {
                    resourceName = resourceName.trim();
                }
                if (resourceName == null || !resourceName.startsWith("http://") && !resourceName.startsWith("https://") && !resourceName.startsWith("file://") && !resourceName.startsWith("ftp://")) break block39;
                int responseCode = 0;
                String responseMessage = null;
                try {
                    FTPClient ftpClient;
                    block40: {
                        URL url = new URL(resourceName);
                        boolean isFTP = false;
                        if (this.entity != null) {
                            String contentType = null;
                            if (resourceName.startsWith("http")) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                                httpURLConnection.setRequestMethod("HEAD");
                                httpURLConnection.connect();
                                contentType = httpURLConnection.getContentType();
                                responseCode = httpURLConnection.getResponseCode();
                                responseMessage = httpURLConnection.getResponseMessage();
                            } else if (resourceName.startsWith("file")) {
                                URLConnection urlConnection = url.openConnection();
                                urlConnection.connect();
                                contentType = urlConnection.getContentType();
                            } else {
                                isFTP = true;
                                contentType = "application/octet-stream";
                            }
                            this.entity.setUrlContentType(contentType);
                        }
                        if (!isFTP) {
                            InputStream filestream = url.openStream();
                            try {
                                successFlag = this.writeRemoteInputStreamIntoDataStorage(filestream);
                                break block37;
                            }
                            catch (IOException e) {
                                this.exception = e;
                                String errorMessage = e.getMessage();
                                if (errorMessage.startsWith(ONLINE_URLS_EXCEPTION_MESSAGE)) {
                                    onlineURLsException = true;
                                }
                                break block37;
                            }
                            finally {
                                filestream.close();
                            }
                        }
                        String[] urlParts = resourceName.split("/");
                        String address = urlParts[2];
                        String dir = "/";
                        for (int i = 3; i < urlParts.length - 1; ++i) {
                            dir = dir + urlParts[i] + "/";
                        }
                        String fileName = urlParts[urlParts.length - 1];
                        ftpClient = new FTPClient();
                        ftpClient.connect(address);
                        ftpClient.login(ANONYMOUS, anonymousFtpPasswd);
                        ftpClient.changeWorkingDirectory(dir);
                        ftpClient.setFileType(2);
                        ftpClient.enterLocalPassiveMode();
                        InputStream filestream = ftpClient.retrieveFileStream(fileName);
                        successFlag = this.writeRemoteInputStreamIntoDataStorage(filestream);
                        try {
                            filestream.close();
                        }
                        catch (IOException e) {
                            this.exception = new DataSourceNotFoundException(String.format("Error closing local file '%s': %s", resourceName, e.getMessage()));
                            onlineURLsException = true;
                        }
                        break block40;
                        catch (IOException e) {
                            block38: {
                                try {
                                    this.exception = e;
                                    String errorMessage = e.getMessage();
                                    if (!errorMessage.startsWith(ONLINE_URLS_EXCEPTION_MESSAGE)) break block38;
                                    onlineURLsException = true;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        filestream.close();
                                    }
                                    catch (IOException e2) {
                                        this.exception = new DataSourceNotFoundException(String.format("Error closing local file '%s': %s", resourceName, e2.getMessage()));
                                        onlineURLsException = true;
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                filestream.close();
                            }
                            catch (IOException e3) {
                                this.exception = new DataSourceNotFoundException(String.format("Error closing local file '%s': %s", resourceName, e3.getMessage()));
                                onlineURLsException = true;
                            }
                        }
                    }
                    if (resourceName.startsWith("ftp") && ftpClient != null) {
                        try {
                            ftpClient.enterLocalActiveMode();
                            ftpClient.logout();
                            ftpClient.disconnect();
                        }
                        catch (IOException e) {
                            this.exception = new DataSourceNotFoundException(String.format("Error disconnecting from FTP with resource '%s': %s", resourceName, e.getMessage()));
                            onlineURLsException = true;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    String eClassName = e.getClass().getName();
                    eMessage = String.format("%s: %s", eClassName, e.getMessage());
                    this.exception = new DataSourceNotFoundException(String.format("The URL '%s' is a malformed URL: %s", resourceName, eMessage));
                }
                catch (IOException e) {
                    String eClassName = e.getClass().getName();
                    eMessage = String.format("%s: %s", eClassName, e.getMessage());
                    if (responseCode > 0) {
                        eMessage = String.format("Response Code: %d %s; %s", responseCode, responseMessage, eMessage);
                    }
                    this.exception = new DataSourceNotFoundException(String.format("The URL '%s' is not reachable: %s", resourceName, eMessage));
                }
            }
            String qualityCheckIdentifier = "onlineURLs";
            QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
            onlineURLsQualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
            if (QualityCheck.shouldRunQualityCheck(this.entity, onlineURLsQualityCheck)) {
                String resourceNameEscaped = this.embedInCDATA(resourceName);
                if (!onlineURLsException) {
                    onlineURLsQualityCheck.setStatus(QualityCheck.Status.valid);
                    onlineURLsQualityCheck.setFound("true");
                    onlineURLsQualityCheck.setExplanation("Succeeded in accessing URL: " + resourceNameEscaped);
                } else {
                    onlineURLsQualityCheck.setFailedStatus();
                    onlineURLsQualityCheck.setFound("false");
                    String explanation = "Failed to access URL: " + resourceNameEscaped;
                    explanation = explanation + "; " + this.embedInCDATA(this.exception.getMessage());
                    onlineURLsQualityCheck.setExplanation(explanation);
                }
                this.entity.addQualityCheck(onlineURLsQualityCheck);
            }
            return successFlag;
        }
        if (resourceName != null && resourceName.startsWith("ecogrid://")) {
            int start = resourceName.indexOf("/", 11) + 1;
            int end = resourceName.indexOf("/", start);
            if (end == -1) {
                end = resourceName.length();
            }
            String ecogridIdentifier = resourceName.substring(start, end);
            return this.getContentFromEcoGridSource(this.ecogridEndPoint, ecogridIdentifier);
        }
        if (resourceName != null && resourceName.startsWith("srb://")) {
            String srbIdentifier = this.transformSRBurlToDocid(resourceName);
            return this.getContentFromEcoGridSource(SRBENDPOINT, srbIdentifier);
        }
        successFlag = false;
        return successFlag;
    }

    private String embedInCDATA(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    protected boolean getContentFromEcoGridSource(String endPoint, String identifier) {
        boolean successFlag = false;
        if (endPoint != null && identifier != null) {
            try {
                NeededOutputStream[] outputStreamList = this.getOutputStreamList();
                if (outputStreamList != null) {
                    boolean oneLoopSuccess = true;
                    for (int i = 0; i < outputStreamList.length; ++i) {
                        NeededOutputStream stream = outputStreamList[i];
                        if (stream != null && stream.getNeeded()) {
                            BufferedOutputStream bos = new BufferedOutputStream(stream.getOutputStream());
                            URL endPointURL = new URL(endPoint);
                            if (this.sessionId != null) {
                                AuthenticatedQueryServiceGetToStreamClient authenticatedEcogridClient = new AuthenticatedQueryServiceGetToStreamClient(endPointURL);
                                authenticatedEcogridClient.get(identifier, this.sessionId, (OutputStream)bos);
                            } else {
                                QueryServiceGetToStreamClient ecogridClient = new QueryServiceGetToStreamClient(endPointURL);
                                ecogridClient.get(identifier, (OutputStream)bos);
                            }
                            bos.flush();
                            bos.close();
                            if (!oneLoopSuccess) continue;
                            successFlag = true;
                            continue;
                        }
                        if (stream != null) {
                            if (!oneLoopSuccess) continue;
                            successFlag = true;
                            continue;
                        }
                        oneLoopSuccess = false;
                        successFlag = false;
                    }
                } else {
                    successFlag = false;
                }
                return successFlag;
            }
            catch (Exception ee) {
                log.error((Object)"DownloadHandler - error getting content from Ecogrid ", (Throwable)ee);
                ee.printStackTrace();
                successFlag = false;
                return successFlag;
            }
        }
        return false;
    }

    private String transformSRBurlToDocid(String srbURL) {
        String docid = null;
        if (srbURL == null) {
            return docid;
        }
        String regex = "seek:";
        srbURL = srbURL.trim();
        String user = SRBUSERNAME;
        String passwd = SRBPASSWD;
        String machineName = SRBMACHINE;
        String replacement = user + ":" + passwd + "@" + machineName;
        docid = srbURL.replaceFirst(regex, replacement);
        return docid;
    }

    private NeededOutputStream[] getOutputStreamList() {
        NeededOutputStream[] list = null;
        if (this.dataStorageClassList != null) {
            list = new NeededOutputStream[this.dataStorageClassList.length];
            for (int i = 0; i < this.dataStorageClassList.length; ++i) {
                NeededOutputStream stream;
                OutputStream osw;
                DataStorageInterface dataStorge = this.dataStorageClassList[i];
                if (dataStorge != null && !dataStorge.doesDataExist(this.url)) {
                    log.debug((Object)"DownloadHandler.startSerialize()");
                    osw = dataStorge.startSerialize(this.url);
                    list[i] = stream = new NeededOutputStream(osw, true);
                    continue;
                }
                if (dataStorge != null) {
                    osw = null;
                    list[i] = stream = new NeededOutputStream(osw, false);
                    continue;
                }
                list[i] = null;
            }
        }
        return list;
    }

    private void finishSerialize(String error) throws IOException {
        if (this.dataStorageClassList != null) {
            for (DataStorageInterface storage : this.dataStorageClassList) {
                if (storage == null) continue;
                storage.finishSerialize(this.url, error);
            }
        }
        log.debug((Object)"DownloadHandler.finishSerialize()");
    }

    public String[] getErrorMessages() {
        return this.errorMessages;
    }

    public String getUrl() {
        return this.url;
    }

    protected boolean writeRemoteInputStreamIntoDataStorage(InputStream inputStream) throws IOException {
        boolean successFlag = false;
        try {
            NeededOutputStream[] outputStreamList = this.getOutputStreamList();
            if (outputStreamList != null) {
                int i;
                byte[] b = new byte[1024];
                int bytesRead = inputStream.read(b, 0, 1024);
                if (bytesRead < 1) {
                    throw new IOException(String.format("%s %s", ONLINE_URLS_EXCEPTION_MESSAGE, "0 bytes were read."));
                }
                int kilobytes = 1;
                if (this.entity != null && this.entity.getFirstKilobyte() == null) {
                    String firstKilobyte = new String(b);
                    this.entity.setFirstKilobyte(firstKilobyte);
                }
                NeededOutputStream stream = null;
                OutputStream os = null;
                while (bytesRead > -1) {
                    for (i = 0; i < outputStreamList.length; ++i) {
                        stream = outputStreamList[i];
                        if (stream == null || !stream.getNeeded()) continue;
                        os = stream.getOutputStream();
                        os.write(b, 0, bytesRead);
                    }
                    bytesRead = inputStream.read(b, 0, 1024);
                    ++kilobytes;
                }
                for (i = 0; i < outputStreamList.length; ++i) {
                    stream = outputStreamList[i];
                    if (stream == null || !stream.getNeeded()) continue;
                    os.flush();
                    os.close();
                }
                successFlag = true;
                log.info((Object)String.format("  Total Kilobytes Read: %d\n", kilobytes));
                log.debug((Object)"DownloadHandler.finishSerialize()");
            } else {
                successFlag = false;
            }
            return successFlag;
        }
        catch (IOException e) {
            successFlag = false;
            e.printStackTrace();
            throw e;
        }
        catch (Exception ee) {
            successFlag = false;
            return successFlag;
        }
    }

    private class NeededOutputStream {
        private OutputStream stream = null;
        private boolean needed = true;

        public NeededOutputStream(OutputStream stream, boolean needed) {
            this.stream = stream;
            this.needed = needed;
        }

        public OutputStream getOutputStream() {
            return this.stream;
        }

        public boolean getNeeded() {
            return this.needed;
        }
    }
}

