/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.concurrent;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.tidy.concurrent.TidyFutureTask;
import org.dataone.tidy.concurrent.TidyJob;

public class TidyJobThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Log logger = LogFactory.getLog(TidyJobThreadPoolExecutor.class);
    private ConcurrentSkipListSet<TidyJob> failures = new ConcurrentSkipListSet();
    private static boolean pause = false;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition unpause = this.pauseLock.newCondition();

    public TidyJobThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    protected <T> TidyFutureTask<T> newTaskFor(Callable<T> callable) {
        return new TidyFutureTask((TidyJob)callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.pauseLock.lock();
        try {
            while (pause) {
                this.unpause.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
        TidyFutureTask task = (TidyFutureTask)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.pauseLock.lock();
        logger.debug((Object)"Pausing Queue");
        try {
            pause = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pauseLock.lock();
        logger.debug((Object)"Resuming Queue");
        try {
            pause = false;
            this.unpause.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public boolean isPaused() {
        return pause;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (throwable == null && runnable == null) {
            logger.error((Object)"Very bad");
            return;
        }
        if (throwable == null && runnable != null) {
            Class<?> runnableClass = runnable.getClass();
            if (runnable instanceof TidyFutureTask) {
                TidyFutureTask task = (TidyFutureTask)runnable;
                TidyJob job = task.getTidyJob();
                if (job == null) {
                    throw new NullPointerException("Cannot determine job from TidyFutureTask");
                }
                try {
                    task.get();
                }
                catch (InterruptedException ie) {
                    logger.error((Object)("afterExecute: " + job.getPid().getValue() + " -InterruptedException: " + ie.getMessage()));
                    logger.error((Object)ie);
                    System.err.print("[" + DateTimeMarshaller.serializeDateToUTC((Date)new Date()) + "] afterExecute: " + job.getPid().getValue() + " StackTrace: ");
                    ie.printStackTrace();
                    job.setFailure(ie);
                    this.failures.add(job);
                }
                catch (Exception e) {
                    logger.error((Object)("afterExecute: " + job.getPid().getValue() + ": " + e));
                    System.err.print("[" + DateTimeMarshaller.serializeDateToUTC((Date)new Date()) + "] afterExecute: " + job.getPid().getValue() + " StackTrace: ");
                    e.printStackTrace();
                    job.setFailure(e);
                    this.failures.add(job);
                }
                logger.debug((Object)("job is of pid " + job.getPid().getValue()));
            }
        }
    }

    public TidyJob getFailure() {
        TidyJob tidyJob = this.failures.pollLast();
        return tidyJob;
    }

    public Set<TidyJob> getFailures() {
        return this.failures;
    }
}

