/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;

public class InclusionsFilter {
    private final List<String> BYPASS_PID_LIST;
    static final int SMALL_BUFF_SIZE = 25000;
    static final int MED_BUFF_SIZE = 50000;
    static final int LARGE_BUFF_SIZE = 100000;
    private static InclusionsFilter inclusions = null;
    List<String> nodeExclusionList = Settings.getConfiguration().getList("tidy.filter.nodes");
    String pidExclusionFile = Settings.getConfiguration().getString("tidy.filter.pids.filepath");

    private InclusionsFilter() {
        ArrayList<String> guidList = new ArrayList<String>();
        if (this.pidExclusionFile != null) {
            File file = new File(this.pidExclusionFile);
            try {
                int amountRead;
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = null;
                int filesize = in.available();
                StringBuilder stringBuilder = new StringBuilder(filesize);
                buffer = filesize < 250000 ? new byte[25000] : (filesize >= 250000 && filesize <= 500000 ? new byte[50000] : new byte[100000]);
                while ((amountRead = in.read(buffer)) != -1) {
                    String inString = new String(buffer);
                    stringBuilder.append(inString.substring(0, amountRead));
                }
                String[] lines = stringBuilder.toString().split("\\r?\\n");
                guidList.addAll(Arrays.asList(lines));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        guidList.addAll(Arrays.asList("OBJECT_FORMAT_LIST.1.1", "OBJECT_FORMAT_LIST.1.2", "OBJECT_FORMAT_LIST.1.3", "OBJECT_FORMAT_LIST.1.4", "OBJECT_FORMAT_LIST.1.5"));
        this.BYPASS_PID_LIST = Collections.unmodifiableList(guidList);
    }

    public List<String> getBypassListFromFile(String filename) {
        List<String> guidList = new ArrayList<String>();
        File file = new File(filename);
        try {
            int amountRead;
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = null;
            int filesize = in.available();
            StringBuilder stringBuilder = new StringBuilder(filesize);
            buffer = filesize < 250000 ? new byte[25000] : (filesize >= 250000 && filesize <= 500000 ? new byte[50000] : new byte[100000]);
            while ((amountRead = in.read(buffer)) != -1) {
                String inString = new String(buffer);
                stringBuilder.append(inString.substring(0, amountRead));
            }
            String[] lines = stringBuilder.toString().split("\\r?\\n");
            guidList = Arrays.asList(lines);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return guidList;
    }

    public static InclusionsFilter getInstance() {
        if (inclusions == null) {
            inclusions = new InclusionsFilter();
        }
        return inclusions;
    }

    public Boolean shouldInclude(Identifier pid, NodeReference nodeId) throws ServiceFailure, NotFound {
        Boolean include = true;
        if (this.nodeExclusionList != null && !this.nodeExclusionList.isEmpty() && this.nodeExclusionList.contains(nodeId.getValue())) {
            include = false;
        }
        if (include.booleanValue() && this.BYPASS_PID_LIST.contains(pid.getValue())) {
            include = false;
        }
        return include;
    }
}

