/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.PrefixMapper;
import org.apache.tomcat.util.SimpleHashtable;
import org.apache.tomcat.util.URLUtil;

public class SimpleMapper1
extends BaseInterceptor {
    ContextManager cm;
    PrefixMapper map = new PrefixMapper();
    int ctExtMapNote = -1;
    int defaultMapNOTE = -1;
    boolean mapCacheEnabled = false;

    public void addContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        String vhost = ctx.getHost();
        String path = ct.getPath();
        String ctxP = ctx.getPath();
        if (ct.getRoles() != null || ct.getTransport() != null) {
            return;
        }
        switch (ct.getMapType()) {
            case 2: {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                this.map.addMapping(vhost, String.valueOf(ctxP) + path.substring(0, path.length() - 2), ct);
                if (this.debug <= 0) break;
                this.log("SM: prefix map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
                break;
            }
            case 4: {
                Container defMapC = ct.getContext().getContainer();
                defMapC.setNote(this.defaultMapNOTE, ct);
                if (this.debug <= 0) break;
                this.log("SM: default map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
                break;
            }
            case 3: {
                Context mapCtx = ct.getContext();
                Container defC = mapCtx.getContainer();
                SimpleHashtable eM = (SimpleHashtable)defC.getNote(this.ctExtMapNote);
                if (eM == null) {
                    eM = new SimpleHashtable();
                    defC.setNote(this.ctExtMapNote, eM);
                }
                eM.put(path.substring(1), ct);
                if (this.debug <= 0) break;
                this.log("SM: extension map " + ctxP + "/" + path + " " + ct + " ");
                break;
            }
            case 1: {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                this.map.addExactMapping(vhost, String.valueOf(ctxP) + path, ct);
                if (this.debug <= 0) break;
                this.log("SM: exact map " + vhost + ":" + ctxP + path + " -> " + ct + " ");
                break;
            }
        }
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        this.map.addMapping(ctx.getHost(), ctx.getPath(), ctx.getContainer());
    }

    public int contextMap(Request req) {
        String path = req.getRequestURI();
        if (path == null) {
            throw new RuntimeException("ASSERT: null path in request URI");
        }
        if (path.indexOf("?") >= 0) {
            throw new RuntimeException("ASSERT: ? in requestURI");
        }
        try {
            Container ctxDef;
            Container defC;
            Container extC;
            Container container;
            String host = req.getServerName();
            if (this.debug > 0) {
                this.cm.log("Host = " + host);
            }
            if ((container = (Container)this.map.getLongestPrefixMatch(host, path)) == null) {
                return 404;
            }
            if (this.debug > 0) {
                this.cm.log("SM: Prefix match " + path + " -> " + container.getPath() + " " + container.getHandler() + " " + container.getRoles());
            }
            this.fixRequestPaths(path, req, container);
            if (container.getHandler() == null && (extC = this.matchExtension(req)) != null) {
                if (extC.getHandler() != null) {
                    this.fixRequestPaths(path, req, extC);
                    container = extC;
                }
                if (this.debug > 0) {
                    this.log("SM: Found extension mapping " + extC.getHandler());
                }
            }
            if (container.getHandler() == null && (defC = (Container)(ctxDef = req.getContext().getContainer()).getNote(this.defaultMapNOTE)) != null && defC.getHandler() != null) {
                this.fixRequestPaths(path, req, defC);
                if (this.debug > 0) {
                    this.log("SM: Found default mapping " + defC.getHandler() + " " + defC.getPath() + " " + defC.getMapType());
                }
            }
            if (this.debug > 0) {
                this.log("SM: After mapping " + req + " " + req.getWrapper());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 500;
        }
        return 0;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.cm = cm;
        this.ctExtMapNote = cm.getNoteId(1, "map.extension");
        this.defaultMapNOTE = cm.getNoteId(1, "tomcat.map.default");
    }

    void fixRequestPaths(String path, Request req, Container container) {
        String s = container.getPath();
        String ctxP = container.getContext().getPath();
        int sLen = s.length();
        int pathLen = path.length();
        int ctxPLen = ctxP.length();
        String pathI = null;
        switch (container.getMapType()) {
            case 2: {
                s = s.substring(0, sLen - 2);
                pathI = path.substring(ctxPLen + sLen - 2, pathLen);
                if (this.debug <= 0) break;
                this.log("Adjust for prefix map " + s + " " + pathI);
                break;
            }
            case 4: {
                s = path.substring(ctxPLen);
                pathI = null;
                if (this.debug <= 0) break;
                this.log("Default map " + s + " " + pathI);
                break;
            }
            case 1: {
                pathI = null;
                if (this.debug <= 0) break;
                this.log("Adjust for path map " + s + " " + pathI + container.getPath());
                break;
            }
            case 3: {
                s = path.substring(ctxPLen);
                pathI = null;
            }
        }
        req.setServletPath(s);
        if (!"".equals(pathI)) {
            req.setPathInfo(pathI);
        }
        Context ctx = container.getContext();
        req.setContext(ctx);
        req.setWrapper(container.getHandler());
        req.setContainer(container);
    }

    Container matchExtension(Request req) {
        SimpleHashtable extM;
        Context ctx = req.getContext();
        String ctxP = ctx.getPath();
        String path = req.getServletPath();
        if (path == null) {
            return null;
        }
        String extension = URLUtil.getExtension(path);
        if (extension == null) {
            return null;
        }
        if (this.debug > 0) {
            this.cm.log("SM: Extension match " + ctxP + " " + path + " " + extension);
        }
        if ((extM = (SimpleHashtable)ctx.getContainer().getNote(this.ctExtMapNote)) == null) {
            return null;
        }
        Container container = (Container)extM.get(extension);
        if (container == null) {
            return null;
        }
        if (container.getHandler() == null) {
            return container;
        }
        return container;
    }

    public void removeContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        String mapping = ct.getPath();
        String ctxP = ctx.getPath();
        mapping = mapping.trim();
        if (this.debug > 0) {
            this.log("Remove mapping " + mapping);
        }
    }

    public void removeContext(ContextManager cm, Context ctx) throws TomcatException {
        if (this.debug > 0) {
            this.log("Removed from maps ");
        }
        this.map.removeAllMappings(ctx.getHost(), ctx.getPath());
    }

    public int requestMap(Request req) {
        String relativePath;
        String requestURI;
        String contextPath = null;
        Context context = req.getContext();
        if (context != null) {
            contextPath = context.getPath();
        }
        if (contextPath == null) {
            contextPath = "";
        }
        if ((requestURI = req.getRequestURI()) == null) {
            requestURI = "";
        }
        if ((relativePath = requestURI.substring(contextPath.length()).toUpperCase()).equals("/META-INF") || relativePath.equals("/WEB-INF") || relativePath.indexOf("/META-INF/") >= 0 || relativePath.indexOf("/WEB-INF/") >= 0) {
            return 404;
        }
        return 0;
    }

    public void setMapCache(boolean v) {
        this.mapCacheEnabled = v;
        this.map.setMapCache(v);
    }
}

