/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.AbstractTestReifiedStatements;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestReifiedStatements
extends ModelTestBase {
    public TestReifiedStatements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTest((Test)new TestSuite(TestStandard.class));
        result.addTest((Test)new TestSuite(TestConvenient.class));
        result.addTest((Test)new TestSuite(TestMinimal.class));
        return result;
    }

    public Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public static class TestMinimal
    extends AbstractTestReifiedStatements {
        public static final ReificationStyle style = ModelFactory.Minimal;

        public TestMinimal(String name) {
            super(name);
        }

        public Model getModel() {
            return ModelFactory.createDefaultModel((ReificationStyle)style);
        }

        public void testStyle() {
            TestMinimal.assertEquals((Object)style, (Object)this.getModel().getReificationStyle());
        }
    }

    public static class TestConvenient
    extends AbstractTestReifiedStatements {
        public static final ReificationStyle style = ModelFactory.Convenient;

        public TestConvenient(String name) {
            super(name);
        }

        public Model getModel() {
            return ModelFactory.createDefaultModel((ReificationStyle)style);
        }

        public void testStyle() {
            TestConvenient.assertEquals((Object)style, (Object)this.getModel().getReificationStyle());
        }
    }

    public static class TestStandard
    extends AbstractTestReifiedStatements {
        public static final ReificationStyle style = ModelFactory.Standard;

        public TestStandard(String name) {
            super(name);
        }

        public Model getModel() {
            return ModelFactory.createDefaultModel((ReificationStyle)style);
        }

        public void testStyle() {
            TestStandard.assertEquals((Object)style, (Object)this.getModel().getReificationStyle());
        }
    }
}

