/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;

public class UtilizationFileReader
extends FileReader {
    private LNLogEntry targetLogEntry = (LNLogEntry)LogEntryType.LOG_FILESUMMARYLN.getNewLogEntry();
    private UtilizationTracker tracker;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationFileReader(EnvironmentImpl env, int readBufferSize, DbLsn startLsn, DbLsn finishLsn, DbLsn endOfFileLsn) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, null, endOfFileLsn, finishLsn);
        this.tracker = env.getUtilizationTracker();
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        LogEntryType type = LogEntryType.findType(logEntryTypeNumber, logEntryTypeVersion);
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.tracker.countNewLogEntry(this.getLastLsn(), type, 14 + this.currentEntrySize);
        return logEntryTypeNumber == LogEntryType.LOG_FILESUMMARYLN.getTypeNum();
    }

    public long getFileNumber() {
        byte[] keyBytes = this.targetLogEntry.getKey().getKey();
        return FileSummaryLN.bytesToFileNumber(keyBytes);
    }

    public FileSummaryLN getFileSummaryLN() {
        return (FileSummaryLN)this.targetLogEntry.getLN();
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.targetLogEntry.readEntry(entryBuffer);
        return true;
    }

    static {
        $assertionsDisabled = !UtilizationFileReader.class.desiredAssertionStatus();
    }
}

