/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.CursorImpl;

public class EventTrace {
    private static int MAX_EVENTS = 1000;
    public static final boolean TRACE_EVENTS = false;
    static int currentEvent = 0;
    static final EventTrace[] events = new EventTrace[MAX_EVENTS];
    static final int[] threadIdHashes = new int[MAX_EVENTS];
    protected String comment;

    public EventTrace(String comment) {
        this.comment = comment;
    }

    public EventTrace() {
        this.comment = null;
    }

    public String toString() {
        return this.comment;
    }

    public static void addEvent(EventTrace event) {
        int nextEventIdx = currentEvent++ % MAX_EVENTS;
        EventTrace.events[nextEventIdx] = event;
        EventTrace.threadIdHashes[nextEventIdx] = System.identityHashCode(Thread.currentThread());
    }

    public static void addEvent(String comment) {
        EventTrace.addEvent(new EventTrace(comment));
    }

    public static void dumpEvents() {
        System.out.println("----- Event Dump -----");
        int j = 0;
        int i = currentEvent;
        while (j < MAX_EVENTS) {
            EventTrace ev = events[i % MAX_EVENTS];
            if (ev != null) {
                int thisEventIdx = i % MAX_EVENTS;
                System.out.print(threadIdHashes[thisEventIdx] + " ");
                System.out.println(j + "(" + thisEventIdx + "): " + ev);
            }
            ++j;
            ++i;
        }
    }

    public static class CursorTrace
    extends EventTrace {
        long nodeId;
        int index;

        public CursorTrace(String comment, long nodeId, int index) {
            super(comment);
            this.nodeId = nodeId;
            this.index = index;
        }

        public static void addEvent(String comment, CursorImpl cursor) {
            long nodeId = cursor.getBIN() == null ? -1L : cursor.getBIN().getNodeId();
            EventTrace.addEvent(new CursorTrace(comment, nodeId, cursor.getIndex()));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.comment);
            sb.append(" BIN: ").append(this.nodeId);
            sb.append(" idx: ").append(this.index);
            return sb.toString();
        }
    }
}

