/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.heuristic;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.GraphStatisticsHeuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCountingUnbound;

public class OptimalNoStats
extends HeuristicBasicPattern {
    private VariableCountingUnbound vcp = null;
    private GraphStatisticsHeuristic gsh = null;
    private GraphStatisticsHandler graphStatisticsHandler = null;

    public OptimalNoStats(Graph graph) {
        this.graphStatisticsHandler = graph.getStatisticsHandler();
        this.vcp = new VariableCountingUnbound();
        if (this.graphStatisticsHandler != null) {
            this.gsh = new GraphStatisticsHeuristic(graph);
        }
    }

    public double getCost(Triple triple1) {
        if (this.gsh == null) {
            return this.vcp.getCost(triple1);
        }
        return this.gsh.getCost(triple1);
    }

    public double getCost(Triple triple1, Triple triple2) {
        double p1 = 0.0;
        double p2 = 0.0;
        if (this.gsh == null) {
            p1 = this.vcp.getCost(triple1);
            p2 = this.vcp.getCost(triple2);
        } else {
            p1 = this.gsh.getCost(triple1);
            p2 = this.gsh.getCost(triple2);
        }
        if (p1 < p2) {
            return p1 + this.vcp.getCost(triple1, triple2);
        }
        return p2 + this.vcp.getCost(triple1, triple2);
    }
}

