/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ExecutionContext
implements FunctionEnv {
    private static boolean TrackAllIterators = false;
    private Context context = null;
    private DatasetGraph dataset = null;
    private Collection openIterators = null;
    private Collection allIterators = null;
    private Graph activeGraph = null;

    public ExecutionContext(ExecutionContext other, Graph activeGraph) {
        this.context = other.context;
        this.dataset = other.dataset;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
        this.activeGraph = activeGraph;
    }

    public ExecutionContext(Context params, Graph activeGraph, DatasetGraph dataset) {
        this.context = params;
        this.dataset = dataset;
        this.openIterators = new ArrayList();
        if (TrackAllIterators) {
            this.allIterators = new ArrayList();
        }
        this.activeGraph = activeGraph;
    }

    public Context getContext() {
        return this.context;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public void openIterator(QueryIterator qIter) {
        this.openIterators.add(qIter);
        if (this.allIterators != null) {
            this.allIterators.add(qIter);
        }
    }

    public void closedIterator(QueryIterator qIter) {
        this.openIterators.remove(qIter);
    }

    public Iterator listOpenIterators() {
        return this.openIterators.iterator();
    }

    public Iterator listAllIterators() {
        if (this.allIterators == null) {
            return null;
        }
        return this.allIterators.iterator();
    }

    public Graph getActiveGraph() {
        return this.activeGraph;
    }
}

