/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpStage;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import com.hp.hpl.jena.sparql.sse.builders.BuilderExpr;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import com.hp.hpl.jena.sparql.sse.builders.BuilderTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BuilderOp {
    protected Map dispatch = new HashMap();
    protected final Build buildTable = new Build(){

        public Op make(ItemList list) {
            Item t = Item.createList(list);
            Table table = BuilderTable.build(t);
            return OpTable.create(table);
        }
    };
    protected final Build buildBGP = new Build(){

        public Op make(ItemList list) {
            BasicPattern triples = new BasicPattern();
            for (int i = 1; i < list.size(); ++i) {
                Item item = list.get(i);
                if (!item.isList()) {
                    BuilderBase.broken(item, "Not a triple structure");
                }
                Triple t = BuilderGraph.buildTriple(item.getList());
                triples.add(t);
            }
            return new OpBGP(triples);
        }
    };
    protected final Build buildQuadPattern = new Build(){

        public Op make(ItemList list) {
            Node g = null;
            BasicPattern bp = new BasicPattern();
            for (int i = 1; i < list.size(); ++i) {
                Item item = list.get(i);
                if (!item.isList()) {
                    BuilderBase.broken(item, "Not a quad structure");
                }
                Quad q = BuilderGraph.buildQuad(item.getList());
                if (g == null) {
                    g = q.getGraph();
                } else if (!g.equals((Object)q.getGraph())) {
                    BuilderBase.broken(item, "Quad has different graph node in quadapttern: " + q);
                }
                bp.add(q.getTriple());
            }
            OpQuadPattern op = new OpQuadPattern(g, bp);
            return op;
        }
    };
    protected final Build buildFilter = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "Malformed filter");
            Item itemExpr = list.get(1);
            Item itemOp = list.get(2);
            Op op = BuilderOp.this.build(itemOp.getList());
            ExprList exprList = BuilderExpr.buildExprOrExprList(itemExpr);
            return OpFilter.filter(exprList, op);
        }
    };
    protected final Build buildJoin = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "Join");
            Op left = BuilderOp.this.build(list, 1);
            Op right = BuilderOp.this.build(list, 2);
            Op op = OpJoin.create(left, right);
            return op;
        }
    };
    protected final Build buildStage = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "Stage");
            Op left = BuilderOp.this.build(list, 1);
            Op right = BuilderOp.this.build(list, 2);
            Op op = OpStage.create(left, right);
            return op;
        }
    };
    protected final Build buildLeftJoin = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, 4, list, "leftjoin: wanted 2 or 3 arguments");
            Op left = BuilderOp.this.build(list, 1);
            Op right = BuilderOp.this.build(list, 2);
            Expr expr = null;
            if (list.size() == 4) {
                expr = BuilderOp.buildExpr(list.get(3));
            }
            Op op = OpLeftJoin.create(left, right, expr);
            return op;
        }
    };
    protected final Build buildDiff = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, 4, list, "diff: wanted 2 arguments");
            Op left = BuilderOp.this.build(list, 1);
            Op right = BuilderOp.this.build(list, 2);
            Op op = OpDiff.create(left, right);
            return op;
        }
    };
    protected final Build buildUnion = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "union");
            Op left = BuilderOp.this.build(list, 1);
            Op right = BuilderOp.this.build(list, 2);
            OpUnion op = new OpUnion(left, right);
            return op;
        }
    };
    protected final Build buildGraph = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "graph");
            Node graph = BuilderNode.buildNode(list.get(1));
            Op sub = BuilderOp.this.build(list, 2);
            return new OpGraph(graph, sub);
        }
    };
    protected final Build buildService = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "service");
            Node service = BuilderNode.buildNode(list.get(1));
            if (!service.isURI() && !service.isVariable()) {
                BuilderBase.broken(list, "Service must provide a URI or variable");
            }
            Op sub = BuilderOp.this.build(list, 2);
            return new OpService(service, sub);
        }
    };
    protected final Build buildProcedure = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(4, 5, list, "proc");
            Node procId = BuilderNode.buildNode(list.get(1));
            if (!procId.isURI() && !procId.isVariable()) {
                BuilderBase.broken(list, "Procedure name must be a URI");
            }
            if (list.size() == 5) {
                PropFuncArg subjArg = BuilderOp.read(list.get(2));
                PropFuncArg objArg = BuilderOp.read(list.get(3));
                Op sub = BuilderOp.this.build(list, 4);
                return new OpProcedure(procId, subjArg, objArg, sub);
            }
            ExprList args = BuilderExpr.buildExprList(list.get(2));
            Op sub = BuilderOp.this.build(list, 3);
            return new OpProcedure(procId, args, sub);
        }
    };
    protected final Build buildToList = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(2, list, "tolist");
            Op sub = BuilderOp.this.build(list, 1);
            OpList op = new OpList(sub);
            return op;
        }
    };
    protected final Build buildGroupBy = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, 4, list, "Group");
            VarExprList vars = BuilderExpr.buildNamedExprList(list.get(1).getList());
            ArrayList aggregators = new ArrayList();
            if (list.size() == 4) {
                VarExprList y = BuilderExpr.buildNamedExprList(list.get(2).getList());
                aggregators.addAll(y.getExprs().values());
                Iterator iter = aggregators.iterator();
                while (iter.hasNext()) {
                    Expr expr = (Expr)iter.next();
                    if (expr instanceof E_Aggregator) continue;
                    BuilderBase.broken(list, "Not a aggregate expression: " + expr);
                }
            }
            Op sub = BuilderOp.this.build(list, list.size() - 1);
            OpGroupAgg op = new OpGroupAgg(sub, vars, aggregators);
            return op;
        }
    };
    protected final Build buildOrderBy = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "Order");
            ItemList conditions = list.get(1).getList();
            ArrayList<SortCondition> x = new ArrayList<SortCondition>();
            for (int i = 0; i < conditions.size(); ++i) {
                int direction = Query.ORDER_DEFAULT;
                Item item = conditions.get(i);
                SortCondition sc = BuilderOp.this.scBuilder(item);
                x.add(sc);
            }
            Op sub = BuilderOp.this.build(list, 2);
            OpOrder op = new OpOrder(sub, x);
            return op;
        }
    };
    protected final Build buildProject = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "project");
            List x = BuilderNode.buildVars(list.get(1).getList());
            Op sub = BuilderOp.this.build(list, 2);
            return new OpProject(sub, x);
        }
    };
    protected final Build buildDistinct = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(2, list, "distinct");
            Op sub = BuilderOp.this.build(list, 1);
            return new OpDistinct(sub);
        }
    };
    protected final Build buildReduced = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(2, list, "reduced");
            Op sub = BuilderOp.this.build(list, 1);
            return new OpReduced(sub);
        }
    };
    protected final Build buildAssign = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(3, list, "assign");
            VarExprList x = BuilderExpr.buildNamedExprList(list.get(1).getList());
            Op sub = BuilderOp.this.build(list, 2);
            return new OpAssign(sub, x);
        }
    };
    protected final Build buildSlice = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(4, list, "slice");
            long start = BuilderNode.buildInt(list, 1, -1);
            long length = BuilderNode.buildInt(list, 2, -1);
            if (start == -1L) {
                start = Query.NOLIMIT;
            }
            if (length == -1L) {
                length = Query.NOLIMIT;
            }
            Op sub = BuilderOp.this.build(list, 3);
            return new OpSlice(sub, start, length);
        }
    };
    protected final Build buildNull = new Build(){

        public Op make(ItemList list) {
            BuilderBase.checkLength(1, list, "null");
            return new OpNull();
        }
    };

    public static Op build(Item item) {
        if (item.isNode()) {
            BuilderBase.broken(item, "Attempt to build op structure from a plain node");
        }
        if (item.isSymbol()) {
            BuilderBase.broken(item, "Attempt to build op structure from a bare symbol");
        }
        BuilderOp b = new BuilderOp();
        return b.build(item.getList());
    }

    public BuilderOp() {
        this.dispatch.put("bgp", this.buildBGP);
        this.dispatch.put("quadpattern", this.buildQuadPattern);
        this.dispatch.put("filter", this.buildFilter);
        this.dispatch.put("graph", this.buildGraph);
        this.dispatch.put("service", this.buildService);
        this.dispatch.put("proc", this.buildProcedure);
        this.dispatch.put("join", this.buildJoin);
        this.dispatch.put("stage", this.buildStage);
        this.dispatch.put("leftjoin", this.buildLeftJoin);
        this.dispatch.put("diff", this.buildDiff);
        this.dispatch.put("union", this.buildUnion);
        this.dispatch.put("tolist", this.buildToList);
        this.dispatch.put("group", this.buildGroupBy);
        this.dispatch.put("order", this.buildOrderBy);
        this.dispatch.put("project", this.buildProject);
        this.dispatch.put("distinct", this.buildDistinct);
        this.dispatch.put("reduced", this.buildReduced);
        this.dispatch.put("assign", this.buildAssign);
        this.dispatch.put(":=", this.buildAssign);
        this.dispatch.put("slice", this.buildSlice);
        this.dispatch.put("table", this.buildTable);
        this.dispatch.put("null", this.buildNull);
    }

    public Op build(ItemList list) {
        Item head;
        String tag;
        Build bob;
        if (list == null) {
            list = null;
        }
        if ((bob = this.findBuild(tag = (head = list.get(0)).getSymbol())) != null) {
            return bob.make(list);
        }
        BuilderBase.broken(head, "Unrecognized algebra operation: " + tag);
        return null;
    }

    public static Expr buildExpr(Item item) {
        return BuilderExpr.buildExpr(item);
    }

    public static List buildExpr(ItemList list) {
        ArrayList<Expr> x = new ArrayList<Expr>();
        for (int i = 0; i < list.size(); ++i) {
            Item itemExpr = list.get(i);
            Expr expr = BuilderOp.buildExpr(itemExpr);
            x.add(expr);
        }
        return x;
    }

    protected Op build(ItemList list, int idx) {
        return this.build(list.get(idx).getList());
    }

    protected Build findBuild(String str2) {
        Iterator iter = this.dispatch.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!str2.equalsIgnoreCase(key)) continue;
            return (Build)this.dispatch.get(key);
        }
        return null;
    }

    private static final PropFuncArg read(Item item) {
        if (item.isNode()) {
            return new PropFuncArg(BuilderNode.buildNode(item));
        }
        if (item.isList()) {
            return new PropFuncArg(BuilderNode.buildNodeList(item));
        }
        BuilderBase.broken(item, "Expected a property function argument (node or list of nodes");
        return null;
    }

    SortCondition scBuilder(Item item) {
        Expr expr;
        int direction = Query.ORDER_DEFAULT;
        if (item.isTagged("asc") || item.isTagged("desc")) {
            BuilderBase.checkList(item);
            BuilderBase.checkLength(2, item.getList(), "Direction corrupt");
            direction = item.isTagged("asc") ? Query.ORDER_ASCENDING : Query.ORDER_DESCENDING;
            item = item.getList().get(1);
        }
        if ((expr = BuilderExpr.buildExpr(item)).isVariable()) {
            return new SortCondition(expr.getNodeVar().asVar(), direction);
        }
        return new SortCondition(expr, direction);
    }

    public static interface Build {
        public Op make(ItemList var1);
    }
}

