/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.matcher;

import java.util.ArrayList;
import java.util.List;

public class KeywordItem {
    protected String keyword;
    protected List<String> types;

    public KeywordItem() {
    }

    public KeywordItem(String keyword) {
        this.keyword = keyword;
        this.types = new ArrayList<String>();
    }

    public KeywordItem(String keyword, List<String> types) {
        this.keyword = keyword;
        this.types = types;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void addType(String type) {
        if (!this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyword);
        boolean first = true;
        for (String type : this.types) {
            if (first) {
                sb.append("(");
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(type);
        }
        if (!this.types.isEmpty()) {
            sb.append(")");
        }
        return sb.toString();
    }
}

