/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.generator;

import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.generator.AnnotationGenerator;
import org.dataone.annotator.store.AnnotatorStore;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;

public class AnnotationUploader {
    private static Log log = LogFactory.getLog(AnnotationUploader.class);
    private AnnotationGenerator generator = null;
    private AnnotatorStore store = null;

    public AnnotationUploader(Session session) throws Exception {
        String generatorClassName = Settings.getConfiguration().getString("annotator.generator.className");
        this.generator = (AnnotationGenerator)Class.forName(generatorClassName).newInstance();
        String storeClassName = Settings.getConfiguration().getString("annotator.store.className");
        try {
            this.store = (AnnotatorStore)Class.forName(storeClassName).getDeclaredConstructor(Session.class).newInstance(session);
        }
        catch (NoSuchMethodException nsme) {
            log.warn((Object)("Could not construct annotator store with session parameter using impl: " + storeClassName));
            this.store = (AnnotatorStore)Class.forName(storeClassName).newInstance();
        }
    }

    public void createAnnotationsFor(List<String> identifiers) throws Exception {
        for (String identifier : identifiers) {
            log.debug((Object)("Generating annotations for: " + identifier));
            Identifier pid = new Identifier();
            pid.setValue(identifier);
            try {
                Map<Identifier, String> annotations = this.generator.generateAnnotations(pid);
                for (Map.Entry<Identifier, String> entry : annotations.entrySet()) {
                    Identifier annotationIdentifier = entry.getKey();
                    String annotationContent = entry.getValue();
                    this.insertOrUpdate(annotationIdentifier, annotationContent);
                }
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String insertOrUpdate(Identifier annotationIdentifier, String annotationContent) throws Exception {
        String id = null;
        log.debug((Object)("Annotation: " + annotationContent));
        if (this.store.exists(annotationIdentifier.getValue())) {
            log.debug((Object)("Updating annotation: " + annotationIdentifier.getValue()));
            id = this.store.update(annotationIdentifier.getValue(), annotationContent);
        } else {
            log.debug((Object)("Creating annotation: " + annotationIdentifier.getValue()));
            id = this.store.create(annotationContent);
        }
        return id;
    }

    public void removeAnnotationsFor(List<String> identifiers) throws Exception {
        for (String identifier : identifiers) {
            log.debug((Object)("Removing annotations for: " + identifier));
            Identifier pid = new Identifier();
            pid.setValue(identifier);
            String searchResultContent = this.store.search("pid=" + identifier);
            JSONObject searchResults = (JSONObject)JSONValue.parse((String)searchResultContent);
            JSONArray annotations = (JSONArray)searchResults.get((Object)"rows");
            for (JSONObject annotation : annotations) {
                String id = annotation.get((Object)"id").toString();
                log.debug((Object)("deleting annotation: " + id));
                try {
                    this.store.delete(id);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void removeAll() throws Exception {
        String indexContent = this.store.index();
        JSONArray annotations = (JSONArray)JSONValue.parse((String)indexContent);
        for (JSONObject annotation : annotations) {
            String id = annotation.get((Object)"id").toString();
            log.debug((Object)("deleting annotation: " + id));
            try {
                this.store.delete(id);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

