/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDouble;
import org.rrd4j.core.RrdLong;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class ArcState
implements RrdUpdater<ArcState> {
    private Archive parentArc;
    private RrdDouble<ArcState> accumValue;
    private RrdLong<ArcState> nanSteps;

    ArcState(Archive parentArc, boolean shouldInitialize) throws IOException {
        this.parentArc = parentArc;
        this.accumValue = new RrdDouble<ArcState>(this);
        this.nanSteps = new RrdLong<ArcState>(this);
        if (shouldInitialize) {
            Header header = parentArc.getParentDb().getHeader();
            long step = header.getStep();
            long lastUpdateTime = header.getLastUpdateTime();
            long arcStep = parentArc.getArcStep();
            long initNanSteps = (Util.normalize(lastUpdateTime, step) - Util.normalize(lastUpdateTime, arcStep)) / step;
            this.accumValue.set(Double.NaN);
            this.nanSteps.set(initNanSteps);
        }
    }

    String dump() throws IOException {
        return "accumValue:" + this.accumValue.get() + " nanSteps:" + this.nanSteps.get() + "\n";
    }

    void setNanSteps(long value) throws IOException {
        this.nanSteps.set(value);
    }

    public long getNanSteps() throws IOException {
        return this.nanSteps.get();
    }

    void setAccumValue(double value) throws IOException {
        this.accumValue.set(value);
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public Archive getParent() {
        return this.parentArc;
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.startTag("ds");
        writer.writeTag("value", this.accumValue.get());
        writer.writeTag("unknown_datapoints", this.nanSteps.get());
        writer.closeTag();
    }

    @Override
    public void copyStateTo(ArcState arcState) throws IOException {
        arcState.accumValue.set(this.accumValue.get());
        arcState.nanSteps.set(this.nanSteps.get());
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

