/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.File;
import java.io.IOException;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.SysRIOT;

public class IRILib {
    private static char[] uri_reserved = new char[]{'!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']'};
    private static char[] uri_non_chars = new char[]{'<', '>', '{', '}', '|', '\\', '`', '^', ' ', '\n', '\r', '\t', '\u00a3'};
    private static char[] charsComponent = new char[]{'!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t', '\u00a3'};
    private static char[] charsFilename = new char[]{'!', '*', '\"', '\'', '(', ')', ';', '@', '&', '=', '+', '$', ',', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t', '~'};
    private static char[] charsPath = new char[]{'!', '*', '\"', '\'', '(', ')', ';', '@', '&', '=', '+', '$', ',', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t'};
    static final String cwd;
    static final String cwdURL;

    public static String fileToIRI(File f) {
        return IRILib.filenameToIRI(f.getAbsolutePath());
    }

    public static String filenameToIRI(String fn) {
        if (fn == null) {
            return cwdURL;
        }
        if (fn.length() == 0) {
            return cwdURL;
        }
        if (fn.startsWith("file:")) {
            return IRILib.normalizeFilenameURI(fn);
        }
        return IRILib.plainFilenameToURL(fn);
    }

    public static String IRIToFilename(String iri2) {
        if (!iri2.startsWith("file:")) {
            throw new AtlasException("Not a file: URI: " + iri2);
        }
        String fn = iri2.startsWith("file:///") ? iri2.substring("file://".length()) : iri2.substring("file:".length());
        return IRILib.decode(fn);
    }

    private static String plainFilenameToURL(String fn) {
        boolean trailingSlash = fn.endsWith("/");
        File file = new File(fn);
        try {
            fn = file.getCanonicalPath();
        }
        catch (IOException e2) {
            fn = file.getAbsolutePath();
        }
        if (trailingSlash && !fn.endsWith("/")) {
            fn = fn + "/";
        }
        if (SysRIOT.isWindows) {
            if (fn.length() >= 2 && fn.charAt(1) == ':') {
                fn = "/" + fn;
            }
            fn = fn.replace('\\', '/');
        }
        fn = IRILib.encodeFileURL(fn);
        return "file://" + fn;
    }

    private static String normalizeFilenameURI(String fn) {
        if (!fn.startsWith("file:/")) {
            String fn2 = fn.substring("file:".length());
            return IRILib.plainFilenameToURL(fn2);
        }
        if (fn.startsWith("file:///")) {
            return fn;
        }
        if (fn.startsWith("file://")) {
            String fn2 = fn.substring("file:/".length());
            return IRILib.plainFilenameToURL(fn2);
        }
        String fn2 = fn.substring("file:".length());
        return IRILib.plainFilenameToURL(fn2);
    }

    public static String encodeUriComponent(String string) {
        String encStr = StrUtils.encodeHex(string, '%', charsComponent);
        return encStr;
    }

    public static String encodeFileURL(String string) {
        String encStr = StrUtils.encodeHex(string, '%', charsFilename);
        return encStr;
    }

    public static String encodeUriPath(String uri) {
        uri = StrUtils.encodeHex(uri, '%', charsPath);
        return uri;
    }

    public static String decode(String string) {
        return StrUtils.decodeHex(string, '%');
    }

    public static String encodeNonASCII(String string) {
        if (!IRILib.containsNonASCII(string)) {
            return string;
        }
        byte[] bytes = StrUtils.asUTF8bytes(string);
        StringBuilder sw = new StringBuilder();
        for (byte b : bytes) {
            if (b > 0) {
                sw.append((char)b);
                continue;
            }
            int hi = (b & 0xF0) >> 4;
            int lo = b & 0xF;
            sw.append('%');
            sw.append(Chars.hexDigitsUC[hi]);
            sw.append(Chars.hexDigitsUC[lo]);
        }
        return sw.toString();
    }

    public static boolean containsNonASCII(String string) {
        boolean clean = true;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch < '\u007f') continue;
            return true;
        }
        return false;
    }

    static {
        String x = new File(".").getAbsolutePath();
        cwd = x = x.substring(0, x.length() - 1);
        cwdURL = IRILib.plainFilenameToURL(cwd);
    }
}

