/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite;

import java.net.URI;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREResource;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.Triple;
import org.dspace.foresite.jena.AgentJena;
import org.dspace.foresite.jena.AggregatedResourceJena;
import org.dspace.foresite.jena.AggregationJena;
import org.dspace.foresite.jena.ProxyJena;
import org.dspace.foresite.jena.ResourceMapJena;
import org.dspace.foresite.jena.TripleJena;

public class OREFactory {
    public static ResourceMap createResourceMap(URI uri) throws OREException {
        ResourceMapJena rem = new ResourceMapJena();
        rem.initialise(uri);
        return rem;
    }

    public static Agent createAgent() {
        AgentJena agent = new AgentJena();
        agent.initialise();
        return agent;
    }

    public static Agent createAgent(URI uri) {
        AgentJena agent = new AgentJena();
        agent.initialise(uri);
        return agent;
    }

    public static Aggregation createAggregation(URI uri) throws OREException {
        AggregationJena aggregation = new AggregationJena();
        aggregation.initialise(uri);
        return aggregation;
    }

    public static AggregatedResource createAggregatedResource(URI uri) throws OREException {
        AggregatedResourceJena ar = new AggregatedResourceJena();
        ar.initialise(uri);
        return ar;
    }

    public static Proxy createProxy(URI uri) {
        ProxyJena proxy = new ProxyJena();
        proxy.initialise(uri);
        return proxy;
    }

    public static Triple createTriple(URI subject, Predicate pred, URI object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(URI subject, Predicate pred, Object object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(OREResource subject, Predicate pred, OREResource object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(OREResource subject, Predicate pred, URI object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(OREResource subject, Predicate pred, Object object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(URI subject, URI relation, URI object) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        Predicate pred = new Predicate(relation);
        triple.relate(pred, object);
        return triple;
    }

    public static Triple createTriple(URI subject, URI relation, Object literal) throws OREException {
        TripleJena triple = new TripleJena();
        triple.initialise(subject);
        Predicate pred = new Predicate(relation);
        triple.relate(pred, literal);
        return triple;
    }
}

