/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.transfer;

import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.repository.RemoteRepository;

public class NoRepositoryConnectorException
extends RepositoryException {
    private final RemoteRepository repository;

    public NoRepositoryConnectorException(RemoteRepository repository) {
        this(repository, NoRepositoryConnectorException.toMessage(repository));
    }

    public NoRepositoryConnectorException(RemoteRepository repository, String message) {
        super(message);
        this.repository = repository;
    }

    private static String toMessage(RemoteRepository repository) {
        if (repository != null) {
            return "No connector available to access repository " + repository.getId() + " (" + repository.getUrl() + ") of type " + repository.getContentType();
        }
        return "No connector available to access repository";
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

