/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.myproxy.MPSingleConnectionProvider;
import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.NoUsableMyProxyServerFoundException;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;

public class MPConnectionProvider<T extends MyProxyConnectable>
implements Provider<T> {
    List<MyProxyServiceFacade> facades;
    MyLoggingFacade logger;

    public MPConnectionProvider(MyLoggingFacade logger, List<MyProxyServiceFacade> facades) {
        this.facades = facades;
        this.logger = logger;
    }

    public MPConnectionProvider(List<MyProxyServiceFacade> facades) {
        this(null, facades);
    }

    protected void info(String x) {
        if (this.logger != null) {
            this.logger.info(x);
        }
    }

    protected void warn(String x) {
        if (this.logger != null) {
            this.logger.warn(x);
        }
    }

    public MPConnectionProvider(MyLoggingFacade logger, MyProxyServiceFacade facade) {
        this.facades = new ArrayList<MyProxyServiceFacade>();
        this.facades.add(facade);
        this.logger = logger;
    }

    public MPConnectionProvider(MyProxyServiceFacade facade) {
        this.facades = new ArrayList<MyProxyServiceFacade>();
        this.facades.add(facade);
    }

    public T findConnection(String userName, String password, long lifetime) throws GeneralSecurityException {
        return this.findConnection(BasicIdentifier.randomID(), userName, password, null, lifetime);
    }

    public T get() {
        return null;
    }

    public T findConnection(Identifier identifier, String userName, String password, String loa, long lifetime) throws GeneralSecurityException {
        MyProxyConnectable mpc = null;
        Throwable lastException = null;
        ArrayList<String> failures = new ArrayList<String>();
        for (MyProxyServiceFacade facade : this.facades) {
            MPSingleConnectionProvider mpSingleConnectionProvider = null;
            try {
                mpSingleConnectionProvider = new MPSingleConnectionProvider(this.logger, userName, password, loa, lifetime, facade);
            }
            catch (IOException e) {
                this.warn("Got IOException connecting to MyProxy:" + e.getMessage());
                throw new GeneralException("IOException getting MyProxy provider:" + e.getMessage(), (Throwable)e);
            }
            mpc = (MyProxyConnectable)mpSingleConnectionProvider.get();
            mpc.setIdentifier(identifier);
            try {
                mpc.open();
                mpc.setIdentifier(identifier);
                this.logFailures("Failures connecting to MyProxy:", failures);
                this.info("MyProxy logon connection succeeded to " + facade.getFacadeConfiguration().getHostname());
                return (T)mpc;
            }
            catch (ConnectionException cx) {
                ConnectionException lastCause = cx;
                for (Throwable t = cx; t != null; t = t.getCause()) {
                    lastCause = t;
                }
                String x = facade.getFacadeConfiguration().getHostname() + ": " + lastCause.getMessage();
                this.info("Error -- MyProxy logon failed for " + x.replace("\n", " "));
                failures.add(x);
                lastException = cx;
            }
        }
        this.logFailures("No usable MyProxy service found:", failures);
        this.info("MyProxy logon connection failed");
        if (lastException instanceof NoUsableMyProxyServerFoundException) {
            throw (NoUsableMyProxyServerFoundException)((Object)lastException);
        }
        throw new NoUsableMyProxyServerFoundException("Error: No usable MyProxy service found.", lastException.getCause() == null ? lastException : lastException.getCause());
    }

    private void logFailures(String msg, ArrayList<String> failures) {
        if (failures.size() != 0) {
            String out = "";
            for (String s : failures) {
                s = s.replace("\n", ", ");
                out = out + "\n       * " + s;
            }
            this.info("\n" + msg + out);
        }
    }
}

