/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableAsList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableCollection
extends AbstractCollection
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    public abstract UnmodifiableIterator iterator();

    @Override
    public Spliterator spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    public final Object[] toArray() {
        int n = this.size();
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        Object[] objectArray = new Object[n];
        this.copyIntoArray(objectArray, 0);
        return objectArray;
    }

    @Override
    @CanIgnoreReturnValue
    public final Object[] toArray(Object[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = ObjectArrays.newArray(objectArray, n);
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        this.copyIntoArray(objectArray, 0);
        return objectArray;
    }

    @Override
    public abstract boolean contains(@NullableDecl Object var1);

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean removeIf(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        return new RegularImmutableAsList(this, this.toArray());
    }

    abstract boolean isPartialView();

    @CanIgnoreReturnValue
    int copyIntoArray(Object[] objectArray, int n) {
        for (Object e : this) {
            objectArray[n++] = e;
        }
        return n;
    }
}

