/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.platform.commons.util.Preconditions;

class AssertLinesMatch {
    private static final int MAX_SNIPPET_LENGTH = 21;
    private static final int MAX_LINES_IN_FAILURE_MESSAGE = 42;

    private AssertLinesMatch() {
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, null);
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, String message) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, (Object)message);
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, Object messageOrSupplier) {
        int actualSize;
        Preconditions.notNull(expectedLines, (String)"expectedLines must not be null");
        Preconditions.notNull(actualLines, (String)"actualLines must not be null");
        if (expectedLines == actualLines) {
            return;
        }
        int expectedSize = expectedLines.size();
        if (expectedSize > (actualSize = actualLines.size())) {
            AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "expected %d lines, but only got %d", expectedSize, actualSize);
        }
        if (expectedSize == actualSize && IntStream.range(0, expectedSize).allMatch(i2 -> AssertLinesMatch.matches((String)expectedLines.get(i2), (String)actualLines.get(i2)))) {
            return;
        }
        AssertLinesMatch.assertLinesMatchWithFastForward(expectedLines, actualLines, messageOrSupplier);
    }

    private static void assertLinesMatchWithFastForward(List<String> expectedLines, List<String> actualLines, Object messageOrSupplier) {
        ArrayDeque<String> expectedDeque = new ArrayDeque<String>(expectedLines);
        ArrayDeque<String> actualDeque = new ArrayDeque<String>(actualLines);
        block0: while (!expectedDeque.isEmpty()) {
            String actualLine;
            String expectedLine = (String)expectedDeque.pop();
            int expectedLineNumber = expectedLines.size() - expectedDeque.size();
            if (actualDeque.isEmpty()) {
                AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "expected line #%d:`%s` not found - actual lines depleted", expectedLineNumber, AssertLinesMatch.snippet(expectedLine));
            }
            if (AssertLinesMatch.matches(expectedLine, actualLine = (String)actualDeque.peek())) {
                actualDeque.pop();
                continue;
            }
            if (AssertLinesMatch.isFastForwardLine(expectedLine)) {
                int fastForwardLimit = AssertLinesMatch.parseFastForwardLimit(expectedLine);
                if (expectedDeque.isEmpty()) {
                    int actualRemaining = actualDeque.size();
                    if (fastForwardLimit == Integer.MAX_VALUE || fastForwardLimit == actualRemaining) {
                        return;
                    }
                    AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "terminal fast-forward(%d) error: fast-forward(%d) expected", fastForwardLimit, actualRemaining);
                }
                if (fastForwardLimit != Integer.MAX_VALUE) {
                    for (int i2 = 0; i2 < fastForwardLimit; ++i2) {
                        actualDeque.pop();
                    }
                    continue;
                }
                expectedLine = (String)expectedDeque.peek();
                while (true) {
                    if (actualDeque.isEmpty()) {
                        AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "fast-forward(\u221e) didn't find: `%s`", AssertLinesMatch.snippet(expectedLine));
                    }
                    if (AssertLinesMatch.matches(expectedLine, (String)actualDeque.peek())) continue block0;
                    actualDeque.pop();
                }
            }
            AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "expected line #%d:`%s` doesn't match", expectedLineNumber, AssertLinesMatch.snippet(expectedLine));
        }
        if (!actualDeque.isEmpty()) {
            AssertLinesMatch.fail(expectedLines, actualLines, messageOrSupplier, "more actual lines than expected: %d", actualDeque.size());
        }
    }

    private static String snippet(String line) {
        if (line.length() <= 21) {
            return line;
        }
        return line.substring(0, 16) + "[...]";
    }

    private static void fail(List<String> expectedLines, List<String> actualLines, Object messageOrSupplier, String format, Object ... args) {
        List<String> expectedLinesForMessage = AssertLinesMatch.truncateForFailureMessage(expectedLines);
        List<String> actualLinesForMessage = AssertLinesMatch.truncateForFailureMessage(actualLines);
        String newLine = System.lineSeparator();
        String message = AssertionUtils.format(newLine + String.join((CharSequence)newLine, expectedLinesForMessage) + newLine, newLine + String.join((CharSequence)newLine, actualLinesForMessage) + newLine, AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + String.format(format, args));
        AssertionUtils.fail(message, String.join((CharSequence)newLine, expectedLines), String.join((CharSequence)newLine, actualLines));
    }

    private static List<String> truncateForFailureMessage(List<String> lines) {
        int diff = lines.size() - 42;
        if (diff <= 0) {
            return lines;
        }
        ArrayList<String> truncatedLines = new ArrayList<String>(lines.subList(0, 42));
        truncatedLines.add(String.format("[omitted %d line(s)]", diff));
        return truncatedLines;
    }

    static boolean isFastForwardLine(String line) {
        return (line = line.trim()).length() >= 4 && line.startsWith(">>") && line.endsWith(">>");
    }

    static int parseFastForwardLimit(String fastForwardLine) {
        String text = fastForwardLine.trim().substring(2, fastForwardLine.length() - 2).trim();
        try {
            int limit = Integer.parseInt(text);
            Preconditions.condition((limit > 0 ? 1 : 0) != 0, () -> String.format("fast-forward(%d) limit must be greater than zero", limit));
            return limit;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    static boolean matches(String expectedLine, String actualLine) {
        Preconditions.notNull((Object)expectedLine, (String)"expected line must not be null");
        Preconditions.notNull((Object)actualLine, (String)"actual line must not be null");
        if (expectedLine.equals(actualLine)) {
            return true;
        }
        try {
            return actualLine.matches(expectedLine);
        }
        catch (PatternSyntaxException ignore) {
            return false;
        }
    }
}

