/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunction3;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;

public class ExprTransformConstantFold
extends ExprTransformCopy {
    private Binding b = null;

    @Override
    public Expr transform(ExprFunction1 func, Expr expr1) {
        if (this.isFoldable(expr1)) {
            try {
                return func.eval(expr1.getConstant());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.transform(func, expr1);
    }

    @Override
    public Expr transform(ExprFunction2 func, Expr expr1, Expr expr2) {
        if (this.isFoldable(expr1, expr2)) {
            try {
                return func.eval(expr1.getConstant(), expr2.getConstant());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.transform(func, expr1, expr2);
    }

    @Override
    public Expr transform(ExprFunction3 func, Expr expr1, Expr expr2, Expr expr3) {
        if (this.isFoldable(expr1, expr2, expr3)) {
            try {
                return func.eval(expr1.getConstant(), expr2.getConstant(), expr3.getConstant());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.transform(func, expr1, expr2, expr3);
    }

    @Override
    public Expr transform(ExprFunctionN func, ExprList args) {
        if (this.isFoldable(args)) {
            ArrayList<NodeValue> args2 = new ArrayList<NodeValue>();
            for (Expr e2 : args) {
                args2.add(e2.getConstant());
            }
            try {
                return func.eval(args2);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.transform(func, args);
    }

    @Override
    public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        Op op = Transformer.transform(new TransformCopy(), this, funcOp.getGraphPattern());
        ExprList newArgs = new ExprList();
        for (int i = 0; i < args.size(); ++i) {
            Expr curr = args.get(i);
            Expr newArg = ExprTransformer.transform((ExprTransform)this, curr);
            newArgs.add(newArg);
        }
        return funcOp.copy(newArgs, op);
    }

    private boolean isFoldable(ExprList exprs) {
        for (Expr e2 : exprs) {
            if (e2 != null && e2.isConstant()) continue;
            return false;
        }
        return true;
    }

    private boolean isFoldable(Expr ... exprs) {
        for (Expr e2 : exprs) {
            if (e2 != null && e2.isConstant()) continue;
            return false;
        }
        return true;
    }
}

