/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MigratingPartition
implements DataSerializable {
    protected int partitionId;
    protected Address from;
    protected Address to;
    protected int replicaIndex;
    private final transient long creationTime = Clock.currentTimeMillis();

    public MigratingPartition() {
    }

    public MigratingPartition(int partitionId, int replicaIndex, Address from, Address to) {
        this.partitionId = partitionId;
        this.from = from;
        this.to = to;
        this.replicaIndex = replicaIndex;
    }

    public Address getFromAddress() {
        return this.from;
    }

    public Address getToAddress() {
        return this.to;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        out.writeInt(this.replicaIndex);
        boolean hasFrom = this.from != null;
        out.writeBoolean(hasFrom);
        if (hasFrom) {
            this.from.writeData(out);
        }
        this.to.writeData(out);
    }

    public void readData(DataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.replicaIndex = in.readInt();
        boolean hasFrom = in.readBoolean();
        if (hasFrom) {
            this.from = new Address();
            this.from.readData(in);
        }
        this.to = new Address();
        this.to.readData(in);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigratingPartition)) {
            return false;
        }
        MigratingPartition that = (MigratingPartition)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.replicaIndex != that.replicaIndex) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + this.replicaIndex;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MigratingPartition");
        sb.append("{partitionId=").append(this.partitionId);
        sb.append(", from=").append(this.from);
        sb.append(", to=").append(this.to);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append('}');
        return sb.toString();
    }
}

