/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.partition.MemberGroup;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMemberGroup
implements MemberGroup {
    private MemberImpl member;

    public SingleMemberGroup() {
    }

    public SingleMemberGroup(MemberImpl member) {
        this.member = member;
    }

    @Override
    public void addMember(MemberImpl member) {
        if (this.member != null) {
            throw new UnsupportedOperationException();
        }
        this.member = member;
    }

    @Override
    public void addMembers(Collection<MemberImpl> members) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMember(MemberImpl member) {
        if (this.member != null && this.member.equals(member)) {
            this.member = null;
        }
    }

    @Override
    public boolean hasMember(MemberImpl member) {
        return this.member != null && this.member.equals(member);
    }

    @Override
    public Iterator<MemberImpl> iterator() {
        return new MemberIterator();
    }

    @Override
    public int size() {
        return this.member != null ? 1 : 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleMemberGroup other = (SingleMemberGroup)obj;
        return !(this.member == null ? other.member != null : !this.member.equals(other.member));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleMemberGroup");
        sb.append("{member=").append(this.member);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberIterator
    implements Iterator<MemberImpl> {
        boolean end = false;

        private MemberIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.end;
        }

        @Override
        public MemberImpl next() {
            if (this.hasNext()) {
                this.end = true;
                return SingleMemberGroup.this.member;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.end) {
                SingleMemberGroup.this.member = null;
            }
        }
    }
}

