/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.Collections;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyNodeInfo {
    private Dependency dependency;
    private String context = "";
    private List<Artifact> relocations = Collections.emptyList();
    private List<Artifact> aliases = Collections.emptyList();
    private VersionConstraint versionConstraint;
    private Version version;
    private String premanagedVersion;
    private String premanagedScope;
    private List<RemoteRepository> repositories = Collections.emptyList();

    public DependencyNodeInfo(Dependency dependency) {
        this.dependency = dependency;
    }

    public DependencyNodeInfo(DependencyNodeInfo info) {
        this.dependency = info.dependency;
        this.context = info.context;
        this.aliases = info.aliases;
        this.relocations = info.relocations;
        this.repositories = info.repositories;
        this.version = info.version;
        this.versionConstraint = info.versionConstraint;
        this.premanagedScope = info.premanagedScope;
        this.premanagedVersion = info.premanagedVersion;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context != null ? context : "";
    }

    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public void setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null || relocations.isEmpty() ? Collections.emptyList() : relocations;
    }

    public List<Artifact> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<Artifact> aliases) {
        this.aliases = aliases == null || aliases.isEmpty() ? Collections.emptyList() : aliases;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setScope(String scope) {
        this.dependency = this.dependency.setScope(scope);
    }

    public void setArtifact(Artifact artifact) {
        this.dependency = this.dependency.setArtifact(artifact);
    }

    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String premanagedVersion) {
        this.premanagedVersion = premanagedVersion;
    }

    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String premanagedScope) {
        this.premanagedScope = premanagedScope;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null || repositories.isEmpty() ? Collections.emptyList() : repositories;
    }
}

