/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.data;

import edu.uiuc.ncsa.security.storage.data.DataDescriptorEntry;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptorEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;

public class DataDescriptors<V extends DataDescriptorEntry>
extends TreeSet<V> {
    HashMap<String, V> entries;

    public HashMap<String, V> getEntries() {
        if (this.entries == null) {
            this.entries = new HashMap();
        }
        return this.entries;
    }

    @Override
    public boolean add(V columnDescriptorEntry) {
        boolean rc = super.add(columnDescriptorEntry);
        this.getEntries().put(((DataDescriptorEntry)columnDescriptorEntry).getName(), columnDescriptorEntry);
        return rc;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean rc = super.addAll(c);
        for (DataDescriptorEntry cde : c) {
            this.getEntries().put(cde.getName(), cde);
        }
        return rc;
    }

    @Override
    public boolean remove(Object o) {
        boolean rc = super.remove(o);
        if (o instanceof ColumnDescriptorEntry) {
            this.getEntries().remove(((ColumnDescriptorEntry)o).getName());
        }
        return rc;
    }

    public V get(String name) {
        if (name == null) {
            return null;
        }
        for (DataDescriptorEntry cde : this) {
            if (!name.equals(cde.getName())) continue;
            return (V)cde;
        }
        return null;
    }
}

