/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.auth.AbstractScopedAuthenticator;
import org.apache.jena.atlas.web.auth.FormLogin;
import org.apache.jena.riot.web.HttpOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsAuthenticator
extends AbstractScopedAuthenticator<FormLogin> {
    private static final Logger LOG = LoggerFactory.getLogger(FormsAuthenticator.class);
    private Map<URI, FormLogin> logins = new HashMap<URI, FormLogin>();

    public FormsAuthenticator(URI target, FormLogin login) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.logins.put(target, login);
    }

    public FormsAuthenticator(Map<URI, FormLogin> logins) {
        this.logins.putAll(logins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(AbstractHttpClient client, HttpContext httpContext, URI target) {
        if (client == null) {
            return;
        }
        FormLogin login = (FormLogin)this.findCredentials(target);
        if (login == null) {
            return;
        }
        FormLogin formLogin = login;
        synchronized (formLogin) {
            BasicCookieStore store;
            if (login.hasCookies()) {
                LOG.info("Using existing cookies to authenticate access to " + target.toString());
                store = login.getCookies();
                if (store != null) {
                    client.setCookieStore((CookieStore)store);
                }
                if (!store.clearExpired(Calendar.getInstance().getTime())) {
                    return;
                }
            }
            try {
                store = new BasicCookieStore();
                client.setCookieStore((CookieStore)store);
                LOG.info("Making login attempt against " + login.getLoginFormURL() + " to obtain authentication for access to " + target.toString());
                HttpPost post = new HttpPost(login.getLoginFormURL());
                post.setEntity(login.getLoginEntity());
                HttpResponse response = client.execute((HttpUriRequest)post, httpContext);
                String payload = HttpOp.readPayload(response.getEntity());
                if (response.getStatusLine().getStatusCode() >= 400) {
                    LOG.warn("Failed to login against " + login.getLoginFormURL() + " to obtain authentication for access to " + target.toString());
                    throw new HttpException(response.getStatusLine().getStatusCode(), "Login attempt failed - " + response.getStatusLine().getReasonPhrase(), payload);
                }
                LOG.info("Successfully logged in against " + login.getLoginFormURL() + " and obtained authentication for access to " + target.toString());
                login.setCookies(client.getCookieStore());
            }
            catch (UnsupportedEncodingException e2) {
                throw new HttpException("UTF-8 encoding not supported on your platform", e2);
            }
            catch (IOException e3) {
                throw new HttpException("Error making login request", e3);
            }
        }
    }

    @Override
    public void invalidate() {
        for (FormLogin login : this.logins.values()) {
            login.clearCookies();
        }
    }

    public void addLogin(URI target, FormLogin login) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.logins.put(target, login);
    }

    @Override
    protected FormLogin getCredentials(URI target) {
        return this.logins.get(target);
    }

    @Override
    protected String getUserNameFromCredentials(FormLogin credentials) {
        return null;
    }

    @Override
    protected char[] getPasswordFromCredentials(FormLogin credentials) {
        return null;
    }
}

