/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

public class Cell<K, V> {
    private final Cell<K, V> previous;
    private final K key;
    private final V value;
    private static final String sep = ", ";

    public Cell() {
        this(null, null, null);
    }

    public Cell(K key, V value) {
        this(key, value, null);
    }

    private Cell(K key, V value, Cell<K, V> previous) {
        this.key = key;
        this.value = value;
        this.previous = previous;
    }

    public Cell<K, V> extend(K key, V value) {
        return new Cell<K, V>(key, value, this);
    }

    public final V find(K k) {
        Cell<K, V> slot = this;
        while (slot != null) {
            if (k.equals(slot.key)) {
                return slot.value;
            }
            slot = slot.previous;
        }
        return null;
    }

    private void str(int level, StringBuilder acc) {
        if (this.key == null && this.value == null) {
            return;
        }
        if (level != 0) {
            acc.append(sep);
        }
        acc.append("(");
        acc.append(this.key.toString());
        acc.append("->");
        acc.append(this.value.toString());
        acc.append(")");
        if (this.previous != null) {
            super.str(level + 1, acc);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        this.str(0, sb);
        sb.append(" }");
        return sb.toString();
    }
}

