/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.foresite.ORETransformer;

public class ForesiteCLI {
    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "transform", false, "Perform a format transformation.  Requires: -i, Optional: -o, -f");
        options.addOption("i", "in", true, "Input file to be parsed; required for -t");
        options.addOption("o", "out", true, "Output file to be written; if not specified output will be written to stdout");
        options.addOption("f", "format", true, "Format of incoming file to be parsed.  Defaults to RDF/XML");
        options.addOption("r", "result", true, "Format of output.  Defaults to RDF/XML");
        CommandLine line = parser.parse(options, args);
        ForesiteCLI cli = new ForesiteCLI();
        if (line.hasOption("t")) {
            if (line.hasOption("i")) {
                File input = new File(line.getOptionValue("i"));
                File output = null;
                if (line.hasOption("o")) {
                    output = new File(line.getOptionValue("o"));
                }
                String inFormat = "RDF/XML";
                if (line.hasOption("f")) {
                    inFormat = line.getOptionValue("f");
                }
                String outFormat = "RDF/XML";
                if (line.hasOption("r")) {
                    outFormat = line.getOptionValue("r");
                }
                cli.transform(input, output, inFormat, outFormat);
            }
            System.exit(0);
        }
        ForesiteCLI.usage(options);
    }

    private void transform(File input, File output, String inFormat, String outFormat) throws Exception {
        FileInputStream fis = new FileInputStream(input);
        OutputStream os = output == null ? new ByteArrayOutputStream() : new FileOutputStream(output);
        ORETransformer.transformToStream(inFormat, outFormat, fis, os);
        if (output == null) {
            System.out.println(os.toString());
        }
        os.flush();
        os.close();
    }

    private static void usage(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("ForesiteCLI -[t] -[iofr]", options);
    }
}

