/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.OREResourceJena;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyJena
extends OREResourceJena
implements Proxy {
    @Override
    public void empty() {
    }

    @Override
    public void detach() throws OREException {
    }

    @Override
    public void initialise(URI uri) {
        this.res = this.model.createResource(uri.toString());
        this.res.addProperty(RDF.type, (RDFNode)ORE.Proxy);
    }

    @Override
    public AggregatedResource getProxyFor() throws OREException {
        try {
            StmtIterator itr = this.res.listProperties(ORE.proxyFor);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = (Resource)statement.getObject();
                AggregatedResource ar = JenaOREFactory.createAggregatedResource(this.model, new URI(resource.getURI()));
                return ar;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setProxyFor(AggregatedResource proxyFor) {
    }

    @Override
    public void setProxyForURI(URI uri) {
        this.res.addProperty(ORE.proxyFor, (RDFNode)this.model.createResource(uri.toString()));
    }

    @Override
    public Aggregation getProxyIn() throws OREException {
        try {
            StmtIterator itr = this.res.listProperties(ORE.proxyIn);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = (Resource)statement.getObject();
                Aggregation agg = JenaOREFactory.createAggregation(this.model, new URI(resource.getURI()));
                return agg;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setProxyIn(Aggregation proxyIn) {
    }

    @Override
    public void setProxyInURI(URI uri) {
        this.res.addProperty(ORE.proxyIn, (RDFNode)this.model.createResource(uri.toString()));
    }

    @Override
    public void assertRelation(URI uri, Proxy proxy) throws OREException {
        this.res.addProperty(this.model.createProperty(uri.toString()), (RDFNode)((ProxyJena)proxy).getResource());
    }

    @Override
    public List<Proxy> getRelated(URI uri) throws OREException {
        try {
            ArrayList<Proxy> related = new ArrayList<Proxy>();
            SimpleSelector selector = new SimpleSelector(this.res, this.model.createProperty(uri.toString()), (RDFNode)null);
            StmtIterator itr = this.model.listStatements((Selector)selector);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                if (!(statement.getObject() instanceof Resource)) continue;
                Proxy proxy = JenaOREFactory.createProxy(this.model, new URI(((Resource)statement.getObject()).getURI()));
                related.add(proxy);
            }
            return related;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setLineage(URI externalProxy) throws OREException {
        this.res.addProperty(ORE.lineage, (RDFNode)this.model.createResource(externalProxy.toString()));
    }

    @Override
    public URI getLineage() throws OREException {
        StmtIterator itr = this.res.listProperties(ORE.lineage);
        try {
            Statement statement;
            if (itr.hasNext() && (statement = itr.nextStatement()).getObject() instanceof Resource) {
                return new URI(((Resource)statement.getObject()).getURI());
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setTypes(List<URI> types) {
        super.setTypes(types);
        SimpleSelector selector = new SimpleSelector(this.res, RDF.type, (RDFNode)ORE.Proxy);
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (!itr.hasNext()) {
            this.res.addProperty(RDF.type, (RDFNode)ORE.Proxy);
        }
    }

    @Override
    public void clearTypes() {
        super.clearTypes();
        this.res.addProperty(RDF.type, (RDFNode)ORE.Proxy);
    }

    @Override
    public Vocab getOREType() throws OREException {
        return Vocab.ore_Proxy;
    }
}

