/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Spliterator;

final class SingletonImmutableList
extends ImmutableList {
    final transient Object element;

    SingletonImmutableList(Object object) {
        this.element = Preconditions.checkNotNull(object);
    }

    public Object get(int n) {
        Preconditions.checkElementIndex(n, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, 1);
        return n == n2 ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

